/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection.preserve;

import java.io.Serializable;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowIdAccessor;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.selection.preserve.PreserveSelectionModel;
import org.eclipse.nebula.widgets.nattable.selection.preserve.Selections;

public class SummaryRowPreserveSelectionModel<T>
extends PreserveSelectionModel<T> {
    public SummaryRowPreserveSelectionModel(IUniqueIndexLayer selectionLayer, IRowDataProvider<T> rowDataProvider, IRowIdAccessor<T> rowIdAccessor) {
        super(selectionLayer, rowDataProvider, rowIdAccessor);
    }

    @Override
    protected Serializable getRowIdByPosition(int rowPosition) {
        if (rowPosition == this.getSummaryRowPosition()) {
            return "SummaryRow";
        }
        return super.getRowIdByPosition(rowPosition);
    }

    @Override
    protected int getRowPositionByRowObject(T rowObject) {
        if (rowObject == null) {
            return this.getSummaryRowPosition();
        }
        return super.getRowPositionByRowObject(rowObject);
    }

    @Override
    protected boolean ignoreVerticalChange(Selections.Row<T> row) {
        return row.getId() == "SummaryRow";
    }

    private int getSummaryRowPosition() {
        int lastPosition = this.selectionLayer.getRowCount() - 1;
        LabelStack configLabelsByPosition = this.selectionLayer.getUnderlyingLayerByPosition(0, 0).getConfigLabelsByPosition(0, lastPosition);
        if (configLabelsByPosition != null && configLabelsByPosition.hasLabel("SummaryRow")) {
            return lastPosition;
        }
        return -1;
    }
}

