/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.client;

import com.google.common.base.Preconditions;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.HashedWheelTimer;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.milo.opcua.stack.client.UaStackClientConfig;
import org.eclipse.milo.opcua.stack.client.security.ClientCertificateValidator;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.channel.EncodingLimits;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.jetbrains.annotations.Nullable;

public class UaStackClientConfigBuilder {
    private EndpointDescription endpoint;
    private KeyPair keyPair;
    private X509Certificate certificate;
    private X509Certificate[] certificateChain;
    private ClientCertificateValidator certificateValidator = new ClientCertificateValidator.InsecureValidator();
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private NioEventLoopGroup eventLoop;
    private HashedWheelTimer wheelTimer;
    private EncodingLimits encodingLimits = EncodingLimits.DEFAULT;
    private UInteger connectTimeout = Unsigned.uint((int)5000);
    private UInteger acknowledgeTimeout = Unsigned.uint((int)5000);
    private UInteger requestTimeout = Unsigned.uint((int)60000);
    private UInteger channelLifetime = Unsigned.uint((int)3600000);

    public UaStackClientConfigBuilder setEndpoint(EndpointDescription endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public UaStackClientConfigBuilder setKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
        return this;
    }

    public UaStackClientConfigBuilder setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
        return this;
    }

    public UaStackClientConfigBuilder setCertificateChain(X509Certificate[] certificateChain) {
        this.certificateChain = certificateChain;
        return this;
    }

    public UaStackClientConfigBuilder setCertificateValidator(ClientCertificateValidator certificateValidator) {
        this.certificateValidator = certificateValidator;
        return this;
    }

    public UaStackClientConfigBuilder setExecutor(ExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public UaStackClientConfigBuilder setScheduledExecutor(ScheduledExecutorService scheduledExecutor) {
        this.scheduledExecutor = scheduledExecutor;
        return this;
    }

    public UaStackClientConfigBuilder setEventLoop(NioEventLoopGroup eventLoop) {
        this.eventLoop = eventLoop;
        return this;
    }

    public UaStackClientConfigBuilder setWheelTimer(HashedWheelTimer wheelTimer) {
        this.wheelTimer = wheelTimer;
        return this;
    }

    public UaStackClientConfigBuilder setEncodingLimits(EncodingLimits encodingLimits) {
        this.encodingLimits = encodingLimits;
        return this;
    }

    public UaStackClientConfigBuilder setConnectTimeout(UInteger connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public UaStackClientConfigBuilder setAcknowledgeTimeout(UInteger acknowledgeTimeout) {
        this.acknowledgeTimeout = acknowledgeTimeout;
        return this;
    }

    public UaStackClientConfigBuilder setRequestTimeout(UInteger requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public UaStackClientConfigBuilder setChannelLifetime(UInteger channelLifetime) {
        this.channelLifetime = channelLifetime;
        return this;
    }

    public UaStackClientConfig build() {
        Preconditions.checkNotNull((Object)this.endpoint, (Object)"endpoint must be non-null");
        if (this.executor == null) {
            this.executor = Stack.sharedExecutor();
        }
        if (this.scheduledExecutor == null) {
            this.scheduledExecutor = Stack.sharedScheduledExecutor();
        }
        if (this.eventLoop == null) {
            this.eventLoop = Stack.sharedEventLoop();
        }
        if (this.wheelTimer == null) {
            this.wheelTimer = Stack.sharedWheelTimer();
        }
        return new UaStackClientConfigImpl(this.endpoint, this.keyPair, this.certificate, this.certificateChain, this.certificateValidator, this.encodingLimits, this.executor, this.scheduledExecutor, this.eventLoop, this.wheelTimer, this.connectTimeout, this.acknowledgeTimeout, this.requestTimeout, this.channelLifetime);
    }

    static class UaStackClientConfigImpl
    implements UaStackClientConfig {
        private final EndpointDescription endpoint;
        private final KeyPair keyPair;
        private final X509Certificate certificate;
        private final X509Certificate[] certificateChain;
        private final ClientCertificateValidator certificateValidator;
        private final EncodingLimits encodingLimits;
        private final ExecutorService executor;
        private final ScheduledExecutorService scheduledExecutor;
        private final NioEventLoopGroup eventLoop;
        private final HashedWheelTimer wheelTimer;
        private final UInteger connectTimeout;
        private final UInteger acknowledgeTimeout;
        private final UInteger requestTimeout;
        private final UInteger channelLifetime;

        UaStackClientConfigImpl(EndpointDescription endpoint, @Nullable KeyPair keyPair, @Nullable X509Certificate certificate, @Nullable X509Certificate[] certificateChain, ClientCertificateValidator certificateValidator, EncodingLimits encodingLimits, ExecutorService executor, ScheduledExecutorService scheduledExecutor, NioEventLoopGroup eventLoop, HashedWheelTimer wheelTimer, UInteger connectTimeout, UInteger acknowledgeTimeout, UInteger requestTimeout, UInteger channelLifetime) {
            this.endpoint = endpoint;
            this.keyPair = keyPair;
            this.certificate = certificate;
            this.certificateChain = certificateChain;
            this.certificateValidator = certificateValidator;
            this.encodingLimits = encodingLimits;
            this.executor = executor;
            this.scheduledExecutor = scheduledExecutor;
            this.eventLoop = eventLoop;
            this.wheelTimer = wheelTimer;
            this.connectTimeout = connectTimeout;
            this.acknowledgeTimeout = acknowledgeTimeout;
            this.requestTimeout = requestTimeout;
            this.channelLifetime = channelLifetime;
        }

        @Override
        public EndpointDescription getEndpoint() {
            return this.endpoint;
        }

        @Override
        public Optional<KeyPair> getKeyPair() {
            return Optional.ofNullable(this.keyPair);
        }

        @Override
        public Optional<X509Certificate> getCertificate() {
            return Optional.ofNullable(this.certificate);
        }

        @Override
        public Optional<X509Certificate[]> getCertificateChain() {
            if (this.certificateChain != null) {
                return Optional.of(this.certificateChain);
            }
            if (this.certificate != null) {
                return Optional.of(new X509Certificate[]{this.certificate});
            }
            return Optional.empty();
        }

        @Override
        public ClientCertificateValidator getCertificateValidator() {
            return this.certificateValidator;
        }

        @Override
        public EncodingLimits getEncodingLimits() {
            return this.encodingLimits;
        }

        @Override
        public UInteger getChannelLifetime() {
            return this.channelLifetime;
        }

        @Override
        public ExecutorService getExecutor() {
            return this.executor;
        }

        @Override
        public ScheduledExecutorService getScheduledExecutor() {
            return this.scheduledExecutor;
        }

        @Override
        public NioEventLoopGroup getEventLoop() {
            return this.eventLoop;
        }

        @Override
        public HashedWheelTimer getWheelTimer() {
            return this.wheelTimer;
        }

        @Override
        public UInteger getConnectTimeout() {
            return this.connectTimeout;
        }

        @Override
        public UInteger getAcknowledgeTimeout() {
            return this.acknowledgeTimeout;
        }

        @Override
        public UInteger getRequestTimeout() {
            return this.requestTimeout;
        }
    }
}

