/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.resource;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.resource.impl.AbstractCompoundSelectable;

public class TypeLibraryResourceDescriptions
extends AbstractCompoundSelectable
implements IResourceDescriptions {
    @Inject
    private IResourceServiceProvider.Registry registry;

    public Iterable<IResourceDescription> getAllResourceDescriptions() {
        return () -> TypeLibraryManager.INSTANCE.getTypeLibraries().stream().flatMap(TypeLibrary::getAllTypes).map(this::getResourceDescription).iterator();
    }

    public IResourceDescription getResourceDescription(URI uri) {
        return this.getResourceDescription(TypeLibraryManager.INSTANCE.getTypeEntryForURI(uri));
    }

    public IResourceDescription getResourceDescription(TypeEntry entry) {
        if (entry == null) {
            return null;
        }
        IResourceServiceProvider resourceServiceProvider = this.registry.getResourceServiceProvider(entry.getURI());
        if (resourceServiceProvider == null) {
            return null;
        }
        IResourceDescription.Manager manager = resourceServiceProvider.getResourceDescriptionManager();
        if (manager == null) {
            return null;
        }
        LibraryElement type = entry.getType();
        if (type == null) {
            return null;
        }
        return manager.getResourceDescription(type.eResource());
    }

    protected Iterable<? extends ISelectable> getSelectables() {
        return this.getAllResourceDescriptions();
    }

    public boolean isEmpty() {
        return TypeLibraryManager.INSTANCE.getTypeLibraries().stream().flatMap(TypeLibrary::getAllTypes).findAny().isEmpty();
    }
}

