/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.util;

import com.google.inject.Inject;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.helpers.ArraySizeHelper;
import org.eclipse.fordiac.ide.model.helpers.ImportHelper;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Import;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STAttribute;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCorePackage;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STImport;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.util.STCorePartitioner;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.Triple;

public abstract class STAbstractCorePartitioner<E extends INamedElement>
implements STCorePartitioner {
    @Inject
    private IEObjectDocumentationProvider documentationProvider;

    protected static Import convertImport(STImport decl) {
        if (decl.getImportedNamespace() == null || decl.getImportedNamespace().isEmpty()) {
            return null;
        }
        Import result = LibraryElementFactory.eINSTANCE.createImport();
        result.setImportedNamespace(decl.getImportedNamespace());
        return result;
    }

    protected VarDeclaration convertInputParameter(STVarDeclaration declaration) {
        VarDeclaration result = this.convertVariable(declaration);
        result.setIsInput(true);
        return result;
    }

    protected VarDeclaration convertOutputParameter(STVarDeclaration declaration) {
        return this.convertVariable(declaration);
    }

    protected VarDeclaration convertInOutParameter(STVarDeclaration declaration) {
        return this.convertInputParameter(declaration);
    }

    protected VarDeclaration convertVariable(STVarDeclaration declaration) {
        VarDeclaration result = LibraryElementFactory.eINSTANCE.createVarDeclaration();
        result.setName(declaration.getName());
        String comment = this.getDocumentationProvider().getDocumentation((EObject)declaration);
        if (comment != null) {
            result.setComment(comment);
        }
        result.setType(STAbstractCorePartitioner.resolveDataType((LibraryElement)declaration.getType(), (EObject)declaration, (DataType)IecTypes.GenericTypes.ANY));
        if (declaration.isArray()) {
            ArraySizeHelper.setArraySize((VarDeclaration)result, (String)STAbstractCorePartitioner.extractArraySize(declaration));
        }
        if (declaration.getDefaultValue() != null) {
            Value value = LibraryElementFactory.eINSTANCE.createValue();
            value.setValue(STAbstractCorePartitioner.extractDefaultValue(declaration));
            result.setValue(value);
        }
        if (declaration.getPragma() != null) {
            declaration.getPragma().getAttributes().stream().filter(STAbstractCorePartitioner::isValidAttribute).map(this::convertAttribute).forEachOrdered(arg_0 -> result.getAttributes().add(arg_0));
        }
        return result;
    }

    protected static boolean isValidParameter(STVarDeclaration declaration) {
        return declaration.getName() != null && !declaration.getName().isEmpty();
    }

    protected static String extractArraySize(STVarDeclaration declaration) {
        return Stream.concat(NodeModelUtils.findNodesForFeature((EObject)declaration, (EStructuralFeature)STCorePackage.eINSTANCE.getSTVarDeclaration_Ranges()).stream(), NodeModelUtils.findNodesForFeature((EObject)declaration, (EStructuralFeature)STCorePackage.eINSTANCE.getSTVarDeclaration_Count()).stream()).map(INode::getText).collect(Collectors.joining(","));
    }

    protected static String extractDefaultValue(STVarDeclaration declaration) {
        return NodeModelUtils.findNodesForFeature((EObject)declaration, (EStructuralFeature)STCorePackage.eINSTANCE.getSTVarDeclaration_DefaultValue()).stream().map(INode::getText).collect(Collectors.joining()).trim();
    }

    protected Attribute convertAttribute(STAttribute attribute) {
        Attribute result = LibraryElementFactory.eINSTANCE.createAttribute();
        result.setName(PackageNameHelper.getFullTypeName((LibraryElement)attribute.getDeclaration()));
        String comment = this.getDocumentationProvider().getDocumentation((EObject)attribute);
        if (comment != null) {
            result.setComment(comment);
        }
        result.setType((DataType)attribute.getDeclaration().getType());
        result.setAttributeDeclaration(attribute.getDeclaration());
        result.setValue(STAbstractCorePartitioner.extractValue(attribute));
        return result;
    }

    protected static boolean isValidAttribute(STAttribute attribute) {
        return attribute.getDeclaration() != null && attribute.getDeclaration().getType() != null && attribute.getValue() != null;
    }

    protected static String extractValue(STAttribute attribute) {
        return NodeModelUtils.findNodesForFeature((EObject)attribute, (EStructuralFeature)STCorePackage.eINSTANCE.getSTAttribute_Value()).stream().map(INode::getText).collect(Collectors.joining()).trim();
    }

    protected static DataType resolveDataType(LibraryElement type, EObject context, DataType defaultType) {
        if (type != null && type.eIsProxy()) {
            TypeLibrary typeLibrary;
            String linkName = STAbstractCorePartitioner.extractLinkName((EObject)type, context);
            if (!linkName.isEmpty() && (typeLibrary = TypeLibraryManager.INSTANCE.getTypeLibraryFromContext(context)) != null) {
                return typeLibrary.getDataTypeLibrary().getType(linkName);
            }
        } else if (type instanceof DataType) {
            DataType dataType = (DataType)type;
            return dataType;
        }
        return defaultType;
    }

    protected static String extractLinkName(EObject proxy, EObject context) {
        return STAbstractCorePartitioner.extractLinkName(EcoreUtil.getURI((EObject)proxy).fragment(), context);
    }

    protected static String extractLinkName(String uriFragment, EObject context) {
        LazyLinkingResource resource;
        Resource resource2 = context.eResource();
        if (resource2 instanceof LazyLinkingResource && (resource = (LazyLinkingResource)resource2).getEncoder().isCrossLinkFragment((Resource)resource, uriFragment)) {
            Triple triple = resource.getEncoder().decode((Resource)resource, uriFragment);
            return resource.getLinkingHelper().getCrossRefNodeAsString((INode)triple.getThird(), true);
        }
        return "";
    }

    protected static void generatePackage(LibraryElement libraryElement, StringBuilder builder) {
        String packageName = PackageNameHelper.getPackageName((LibraryElement)libraryElement);
        if (!packageName.isBlank()) {
            builder.append("PACKAGE ");
            builder.append(packageName);
            builder.append(";");
            builder.append("\n");
            builder.append("\n");
        }
    }

    protected static void generateImports(LibraryElement libraryElement, StringBuilder builder) {
        ImportHelper.getImports((LibraryElement)libraryElement).forEach(imp -> {
            builder.append("IMPORT ");
            builder.append(imp.getImportedNamespace());
            builder.append(";");
            builder.append("\n");
        });
        if (!ImportHelper.getImports((LibraryElement)libraryElement).isEmpty()) {
            builder.append("\n");
        }
    }

    protected static void generateVariable(VarDeclaration varDeclaration, StringBuilder builder) {
        builder.append(varDeclaration.getName());
        builder.append(" : ");
        builder.append(varDeclaration.getFullTypeName());
        if (varDeclaration.getValue() != null && varDeclaration.getValue().getValue() != null && !varDeclaration.getValue().getValue().isBlank()) {
            builder.append(" := ");
            builder.append(varDeclaration.getValue().getValue());
        }
        builder.append(";");
        if (varDeclaration.getComment() != null && !varDeclaration.getComment().isBlank()) {
            builder.append(" // ");
            builder.append(varDeclaration.getComment());
        }
    }

    protected static void handleDuplicates(List<? extends INamedElement> result) {
        result.stream().collect(Collectors.groupingBy(INamedElement::getName)).forEach((name, duplicates) -> IntStream.range(1, duplicates.size()).forEach(index -> ((INamedElement)duplicates.get(index)).setName(name + "_" + index)));
    }

    protected IEObjectDocumentationProvider getDocumentationProvider() {
        return this.documentationProvider;
    }
}

