/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.ui.providers.CreationCommand;

public class CreateAttributeCommand
extends CreationCommand
implements ScopedCommand {
    private final ConfigurableObject configurableObject;
    private Attribute attribute;
    private final String name;
    private final String comment;
    private final DataType dataType;
    private final AttributeDeclaration attributeDecl;
    private final String value;
    private final int index;
    static final String DEFAULT_ATTRIBUTE_NAME = "Attribute1";

    private CreateAttributeCommand(ConfigurableObject configurableObject, String name, String comment, DataType dataType, AttributeDeclaration attributeDecl, String value, int index) {
        this.configurableObject = Objects.requireNonNull(configurableObject);
        this.name = name;
        this.comment = comment;
        this.dataType = dataType;
        this.attributeDecl = attributeDecl;
        this.value = value;
        this.index = index;
    }

    public static CreateAttributeCommand withDefaults(ConfigurableObject configurableObject) {
        return CreateAttributeCommand.forTemplate(configurableObject, null, -1);
    }

    public static CreateAttributeCommand forTemplate(ConfigurableObject configurableObject, Attribute template, int index) {
        if (template != null) {
            return CreateAttributeCommand.forValues(configurableObject, template.getName(), template.getComment(), template.getType(), template.getAttributeDeclaration(), template.getValue(), index);
        }
        return CreateAttributeCommand.forValues(configurableObject, DEFAULT_ATTRIBUTE_NAME, "", (DataType)IecTypes.ElementaryTypes.STRING, null, "", index);
    }

    public static CreateAttributeCommand forValues(ConfigurableObject configurableObject, String name, String comment, DataType dataType, AttributeDeclaration attributeDecl, String value, int index) {
        return new CreateAttributeCommand(configurableObject, name == null ? DEFAULT_ATTRIBUTE_NAME : name, comment, dataType, attributeDecl, value, index >= 0 && index <= configurableObject.getAttributes().size() ? index : configurableObject.getAttributes().size());
    }

    public void execute() {
        this.attribute = LibraryElementFactory.eINSTANCE.createAttribute();
        this.attribute.setName(this.name);
        this.attribute.setComment(this.comment);
        this.attribute.setType(this.dataType);
        this.attribute.setAttributeDeclaration(this.attributeDecl);
        this.attribute.setValue(this.value);
        this.configurableObject.getAttributes().add(this.index, (Object)this.attribute);
        if (this.attributeDecl == null) {
            this.attribute.setName(NameRepository.createUniqueName((INamedElement)this.attribute, (String)this.name));
        }
    }

    public void undo() {
        this.configurableObject.getAttributes().remove((Object)this.attribute);
    }

    public void redo() {
        this.configurableObject.getAttributes().add(this.index, (Object)this.attribute);
    }

    public Object getCreatedElement() {
        return this.attribute;
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(this.configurableObject);
    }
}

