/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.gef.commands.Command;

public class RemoveElementsFromGroup
extends Command
implements ScopedCommand {
    private final Group sourceGroup;
    private final Position offset;
    private final List<FBNetworkElement> elements;

    public RemoveElementsFromGroup(Collection<FBNetworkElement> elements, Point offset) {
        this.elements = new ArrayList<FBNetworkElement>(elements);
        this.sourceGroup = RemoveElementsFromGroup.getGroup(this.elements);
        this.offset = CoordinateConverter.INSTANCE.createPosFromScreenCoordinates(offset.x, offset.y);
    }

    public RemoveElementsFromGroup(Collection<FBNetworkElement> elements) {
        this.elements = new ArrayList<FBNetworkElement>(elements);
        this.sourceGroup = RemoveElementsFromGroup.getGroup(this.elements);
        this.offset = RemoveElementsFromGroup.getOffsetFromGroup(this.sourceGroup);
    }

    public boolean canExecute() {
        return this.elements.isEmpty() || this.sourceGroup != null && this.allElementsFromSameGroup();
    }

    public void execute() {
        this.performRemove();
    }

    public void undo() {
        this.elements.forEach(el -> el.setGroup(this.sourceGroup));
        FBNetworkHelper.moveFBNetworkByOffset(this.elements, (double)(-this.offset.getX()), (double)(-this.offset.getY()));
    }

    public void redo() {
        this.performRemove();
    }

    private void performRemove() {
        this.elements.forEach(el -> el.setGroup(null));
        FBNetworkHelper.moveFBNetworkByOffset(this.elements, (Position)this.offset);
        FBNetworkHelper.selectElements(this.elements);
    }

    private static Group getGroup(List<FBNetworkElement> elements) {
        if (!elements.isEmpty()) {
            return elements.get(0).getGroup();
        }
        return null;
    }

    private boolean allElementsFromSameGroup() {
        return this.elements.stream().allMatch(el -> this.sourceGroup.equals(el.getGroup()));
    }

    private static Position getOffsetFromGroup(Group sourceGroup) {
        if (sourceGroup != null) {
            return sourceGroup.getPosition();
        }
        return LibraryElementFactory.eINSTANCE.createPosition();
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        if (this.sourceGroup != null) {
            return Set.of(this.sourceGroup);
        }
        return Set.of();
    }
}

