/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DelayedFiles {
    private final List<FileObject> storage = new ArrayList<FileObject>(2);

    public Path write(Path path, CharSequence data) {
        if (DelayedFiles.hasChangedContent(path, data)) {
            this.storage.add(new FileObject(path, data));
        }
        return path;
    }

    public Iterable<StoredFiles> write(boolean forceOverwrite) throws IOException {
        ArrayList<StoredFiles> ret = new ArrayList<StoredFiles>(this.storage.size());
        for (FileObject fo : this.storage) {
            File o = null;
            File f = fo.path().toFile();
            if (!forceOverwrite && f.exists()) {
                o = DelayedFiles.createBakFile(f);
            }
            if (fo.path().getParent() != null) {
                Files.createDirectories(fo.path().getParent(), new FileAttribute[0]);
            }
            Files.writeString(fo.path(), fo.data(), StandardCharsets.UTF_8, new OpenOption[0]);
            ret.add(new StoredFiles(o, f));
        }
        this.clear();
        return ret;
    }

    public boolean exist() {
        return this.storage.stream().anyMatch(fo -> fo.path().toFile().exists());
    }

    public void clear() {
        this.storage.clear();
    }

    public List<String> getFilenames() {
        return this.storage.stream().map(item -> item.path().getFileName().toString()).toList();
    }

    private static boolean hasChangedContent(Path p, CharSequence data) {
        try {
            return !Files.readString(p).equals(data);
        }
        catch (IOException e) {
            return true;
        }
    }

    private static File createBakFile(File in) throws IOException {
        File f;
        String path = in.getAbsolutePath() + ".bak";
        int i = 1;
        String temp = path;
        while ((f = new File(temp)).exists()) {
            temp = path + i;
            ++i;
        }
        Files.copy(in.toPath(), f.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return f;
    }

    private record FileObject(Path path, CharSequence data) {
        public FileObject {
            Objects.requireNonNull(path);
            Objects.requireNonNull(data);
        }
    }

    public record StoredFiles(File oldFile, File newFile) {
    }
}

