/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide;

import java.util.OptionalDouble;
import org.eclipse.fordiac.ide.contractSpec.TimeExpr;
import org.eclipse.fordiac.ide.contractSpec.Unit;

public class Utils {
    public static OptionalDouble timeExpr2Ns(TimeExpr expr) {
        if (expr == null) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(Utils.getInNs(expr.getValue(), expr.getUnit()));
    }

    public static double getInNs(double value, Unit unit) {
        return switch (unit) {
            case Unit.S -> value * 1.0E9;
            case Unit.MS -> value * 1000000.0;
            case Unit.US -> value * 1000.0;
            case Unit.NS -> value;
            default -> throw new MatchException(null, null);
        };
    }

    public static String nsToString(double ns) {
        Unit unit = Utils.getFittingUnit(ns);
        double v = ns / Utils.getInNs(1.0, unit);
        return String.valueOf(v) + String.valueOf((Object)unit);
    }

    public static Unit getFittingUnit(double value) {
        if (value >= 1.0E9) {
            return Unit.S;
        }
        if (value >= 1000000.0) {
            return Unit.MS;
        }
        if (value >= 1000.0) {
            return Unit.US;
        }
        return Unit.NS;
    }

    private Utils() {
        throw new UnsupportedOperationException();
    }
}

