/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Queue;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.EndLabelPreprocessor;
import org.eclipse.elk.alg.layered.options.EdgeLabelSideSelection;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.LabelSide;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class LabelSideSelector
implements ILayoutProcessor<LGraph> {
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        EdgeLabelSideSelection mode = (EdgeLabelSideSelection)((Object)layeredGraph.getProperty(LayeredOptions.EDGE_LABELS_SIDE_SELECTION));
        monitor.begin("Label side selection (" + String.valueOf((Object)mode) + ")", 1.0f);
        switch (mode) {
            case ALWAYS_UP: {
                this.sameSide(layeredGraph, LabelSide.ABOVE);
                break;
            }
            case ALWAYS_DOWN: {
                this.sameSide(layeredGraph, LabelSide.BELOW);
                break;
            }
            case DIRECTION_UP: {
                this.basedOnDirection(layeredGraph, LabelSide.ABOVE);
                break;
            }
            case DIRECTION_DOWN: {
                this.basedOnDirection(layeredGraph, LabelSide.BELOW);
                break;
            }
            case SMART_UP: {
                this.smart(layeredGraph, LabelSide.ABOVE);
                break;
            }
            case SMART_DOWN: {
                this.smart(layeredGraph, LabelSide.BELOW);
            }
        }
        monitor.done();
    }

    private void sameSide(LGraph graph, LabelSide labelSide) {
        for (Layer layer : graph) {
            for (LNode node : layer) {
                if (node.getType() == LNode.NodeType.LABEL) {
                    this.applyLabelSide(node, labelSide);
                }
                for (LEdge edge : node.getOutgoingEdges()) {
                    this.applyLabelSide(edge, labelSide);
                }
            }
        }
    }

    private void basedOnDirection(LGraph graph, LabelSide sideForRightwardEdges) {
        for (Layer layer : graph) {
            for (LNode node : layer) {
                if (node.getType() == LNode.NodeType.LABEL) {
                    LabelSide side = this.doesEdgePointRight(node) ? sideForRightwardEdges : sideForRightwardEdges.opposite();
                    this.applyLabelSide(node, side);
                }
                for (LEdge edge : node.getOutgoingEdges()) {
                    LabelSide side = this.doesEdgePointRight(edge) ? sideForRightwardEdges : sideForRightwardEdges.opposite();
                    this.applyLabelSide(edge, side);
                }
            }
        }
    }

    private void smart(LGraph graph, LabelSide defaultSide) {
        ArrayDeque<LNode> dummyNodeQueue = new ArrayDeque<LNode>();
        for (Layer layer : graph) {
            boolean topGroup = true;
            int labelDummiesInQueue = 0;
            for (LNode node : layer) {
                switch (node.getType()) {
                    case LABEL: {
                        ++labelDummiesInQueue;
                    }
                    case LONG_EDGE: {
                        dummyNodeQueue.add(node);
                        break;
                    }
                    case NORMAL: {
                        this.smartForRegularNode(node, defaultSide);
                    }
                    default: {
                        if (!dummyNodeQueue.isEmpty()) {
                            this.smartForConsecutiveDummyNodeRun(dummyNodeQueue, labelDummiesInQueue, topGroup, false, defaultSide);
                        }
                        topGroup = false;
                        labelDummiesInQueue = 0;
                    }
                }
            }
            if (dummyNodeQueue.isEmpty()) continue;
            this.smartForConsecutiveDummyNodeRun(dummyNodeQueue, labelDummiesInQueue, topGroup, true, defaultSide);
        }
    }

    private void smartForConsecutiveDummyNodeRun(Deque<LNode> dummyNodes, int labelDummyCount, boolean topGroup, boolean bottomGroup, LabelSide defaultSide) {
        assert (!dummyNodes.isEmpty());
        if (topGroup && (!bottomGroup || dummyNodes.size() > 1) && labelDummyCount == 1 && dummyNodes.peek().getType() == LNode.NodeType.LABEL) {
            this.applyLabelSide(dummyNodes.peek(), LabelSide.ABOVE);
        } else if (bottomGroup && (!topGroup || dummyNodes.size() > 1) && labelDummyCount == 1 && dummyNodes.peekLast().getType() == LNode.NodeType.LABEL) {
            this.applyLabelSide(dummyNodes.peekLast(), LabelSide.BELOW);
        } else if (dummyNodes.size() == 2) {
            this.applyLabelSide(dummyNodes.poll(), LabelSide.ABOVE);
            this.applyLabelSide(dummyNodes.poll(), LabelSide.BELOW);
        } else {
            this.applyForDummyNodeRunWithSimpleLoops(dummyNodes, labelDummyCount, defaultSide);
        }
        dummyNodes.clear();
    }

    private void applyForDummyNodeRunWithSimpleLoops(Collection<LNode> dummyNodes, int labelDummyCount, LabelSide defaultSide) {
        ArrayList labelDummyRun = Lists.newArrayListWithCapacity((int)dummyNodes.size());
        LNode prevLongEdgeSource = null;
        LNode prevLongEdgeTarget = null;
        for (LNode currentDummy : dummyNodes) {
            assert (currentDummy.getType() == LNode.NodeType.LABEL || currentDummy.getType() == LNode.NodeType.LONG_EDGE);
            LNode currLongEdgeSource = this.getLongEdgeEndNode(currentDummy, true);
            LNode currLongEdgeTarget = this.getLongEdgeEndNode(currentDummy, false);
            if (prevLongEdgeSource != currLongEdgeSource || prevLongEdgeTarget != currLongEdgeTarget) {
                this.applyLabelSidesToLabelDummyRun(labelDummyRun, defaultSide);
                prevLongEdgeSource = currLongEdgeSource;
                prevLongEdgeTarget = currLongEdgeTarget;
            }
            labelDummyRun.add(currentDummy);
        }
        this.applyLabelSidesToLabelDummyRun(labelDummyRun, defaultSide);
    }

    private LNode getLongEdgeEndNode(LNode labelDummy, boolean source) {
        LPort endPort = (LPort)((Object)labelDummy.getProperty(source ? InternalProperties.LONG_EDGE_SOURCE : InternalProperties.LONG_EDGE_TARGET));
        return endPort == null ? null : endPort.getNode();
    }

    private void applyLabelSidesToLabelDummyRun(List<LNode> labelDummyRun, LabelSide defaultSide) {
        if (!labelDummyRun.isEmpty()) {
            if (labelDummyRun.size() == 2) {
                this.applyLabelSide(labelDummyRun.get(0), LabelSide.ABOVE);
                this.applyLabelSide(labelDummyRun.get(1), LabelSide.BELOW);
            } else {
                for (LNode dummyNode : labelDummyRun) {
                    this.applyLabelSide(dummyNode, defaultSide);
                }
            }
            labelDummyRun.clear();
        }
    }

    private void smartForRegularNode(LNode node, LabelSide defaultSide) {
        ArrayDeque<List<LLabel>> endLabelQueue = new ArrayDeque<List<LLabel>>(node.getPorts().size());
        PortSide currentPortSide = null;
        for (LPort port : node.getPorts()) {
            List<LLabel> portEndLabels;
            if (port.getSide() != currentPortSide) {
                if (!endLabelQueue.isEmpty()) {
                    this.smartForRegularNodePortEndLabels(endLabelQueue, currentPortSide, defaultSide);
                }
                endLabelQueue.clear();
                currentPortSide = port.getSide();
            }
            if ((portEndLabels = EndLabelPreprocessor.gatherLabels(port)) == null) continue;
            endLabelQueue.add(portEndLabels);
        }
        if (!endLabelQueue.isEmpty()) {
            this.smartForRegularNodePortEndLabels(endLabelQueue, currentPortSide, defaultSide);
        }
    }

    private void smartForRegularNodePortEndLabels(Queue<List<LLabel>> endLabelQueue, PortSide portSide, LabelSide defaultSide) {
        assert (!endLabelQueue.isEmpty());
        assert (portSide != null);
        if (endLabelQueue.size() == 2) {
            if (portSide == PortSide.NORTH || portSide == PortSide.EAST) {
                this.applyLabelSide(endLabelQueue.poll(), LabelSide.ABOVE);
                this.applyLabelSide(endLabelQueue.poll(), LabelSide.BELOW);
            } else {
                this.applyLabelSide(endLabelQueue.poll(), LabelSide.BELOW);
                this.applyLabelSide(endLabelQueue.poll(), LabelSide.ABOVE);
            }
        } else {
            for (List list : endLabelQueue) {
                this.applyLabelSide(list, defaultSide);
            }
        }
    }

    private void applyLabelSide(LNode labelDummy, LabelSide side) {
        if (labelDummy.getType() == LNode.NodeType.LABEL) {
            LabelSide effectiveSide = labelDummy.isInlineEdgeLabel() ? LabelSide.INLINE : side;
            labelDummy.setProperty(InternalProperties.LABEL_SIDE, effectiveSide);
            if (effectiveSide != LabelSide.BELOW) {
                LEdge originEdge = (LEdge)((Object)labelDummy.getProperty(InternalProperties.ORIGIN));
                double thickness = (Double)originEdge.getProperty(LayeredOptions.EDGE_THICKNESS);
                double portPos = 0.0;
                if (effectiveSide == LabelSide.ABOVE) {
                    portPos = labelDummy.getSize().y - Math.ceil(thickness / 2.0);
                } else if (effectiveSide == LabelSide.INLINE) {
                    portPos = Math.ceil(labelDummy.getSize().y - (Double)labelDummy.getGraph().getProperty(LayeredOptions.SPACING_EDGE_LABEL) - thickness) / 2.0;
                    labelDummy.getSize().y -= ((Double)labelDummy.getGraph().getProperty(LayeredOptions.SPACING_EDGE_LABEL)).doubleValue();
                    labelDummy.getSize().y -= thickness;
                }
                for (LPort port : labelDummy.getPorts()) {
                    port.getPosition().y = portPos;
                }
            }
        }
    }

    private void applyLabelSide(LEdge edge, LabelSide side) {
        for (LLabel label : edge.getLabels()) {
            label.setProperty(InternalProperties.LABEL_SIDE, side);
        }
    }

    private void applyLabelSide(List<LLabel> labels, LabelSide side) {
        for (LLabel label : labels) {
            label.setProperty(InternalProperties.LABEL_SIDE, side);
        }
    }

    private boolean doesEdgePointRight(LEdge edge) {
        return (Boolean)edge.getProperty(InternalProperties.REVERSED) == false;
    }

    private boolean doesEdgePointRight(LNode labelDummy) {
        assert (labelDummy.getType() == LNode.NodeType.LABEL);
        assert (labelDummy.getIncomingEdges().iterator().hasNext());
        assert (labelDummy.getOutgoingEdges().iterator().hasNext());
        LEdge incoming = labelDummy.getIncomingEdges().iterator().next();
        LEdge outgoing = labelDummy.getOutgoingEdges().iterator().next();
        return this.doesEdgePointRight(incoming) || this.doesEdgePointRight(outgoing);
    }
}

