/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.deployment.DeploymentCoordinator;
import org.eclipse.fordiac.ide.deployment.IDeviceManagementCommunicationHandler;
import org.eclipse.fordiac.ide.deployment.Messages;
import org.eclipse.fordiac.ide.deployment.data.ConnectionDeploymentData;
import org.eclipse.fordiac.ide.deployment.data.DeviceDeploymentData;
import org.eclipse.fordiac.ide.deployment.data.FBDeploymentData;
import org.eclipse.fordiac.ide.deployment.data.ResourceDeploymentData;
import org.eclipse.fordiac.ide.deployment.devResponse.Resource;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.DeviceManagementInteractorFactory;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.deployment.util.DeploymentHelper;
import org.eclipse.fordiac.ide.deployment.util.IDeploymentListener;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DownloadRunnable
implements IRunnableWithProgress,
IDeploymentListener {
    private final List<DeviceDeploymentData> deploymentData;
    private final IDeviceManagementCommunicationHandler overrideDevMgmCommHandler;
    private final IDeploymentListener outputView;
    private final String profile;
    private IProgressMonitor curMonitor;
    private IStatus result = Status.OK_STATUS;
    private boolean overrideAll = false;

    public DownloadRunnable(List<DeviceDeploymentData> deploymentData, IDeviceManagementCommunicationHandler overrideDevMgmCommHandler, IDeploymentListener outputView, String profile) {
        this.deploymentData = deploymentData;
        this.overrideDevMgmCommHandler = overrideDevMgmCommHandler;
        this.outputView = outputView;
        this.profile = profile;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.curMonitor = monitor;
        monitor.beginTask(Messages.DeploymentCoordinator_LABEL_PerformingDownload, this.calculateWorkAmount());
        for (DeviceDeploymentData devData : this.deploymentData) {
            if (monitor.isCanceled()) {
                throw new InterruptedException(Messages.DeploymentCoordinator_LABEL_DownloadAborted);
            }
            this.deployDevice(devData);
        }
        monitor.done();
    }

    private void deployDevice(DeviceDeploymentData devData) throws InterruptedException {
        IDeviceManagementInteractor executor = DeviceManagementInteractorFactory.INSTANCE.getDeviceManagementInteractor(devData.getDevice(), this.overrideDevMgmCommHandler, this.profile);
        if (executor != null) {
            this.addDeploymentListener(executor);
            try {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (IDeviceManagementInteractor.IDeviceManagementInteractorCloser closer = executor::disconnect;){
                        executor.connect();
                        this.queryTypes(devData, executor);
                        this.deployResources(devData, executor);
                        this.deployDeviceData(devData, executor);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (DeploymentException e) {
                    this.handleDeploymentException(devData.getDevice(), e);
                    this.removeDeploymentListener(executor);
                }
            }
            finally {
                this.removeDeploymentListener(executor);
            }
        } else {
            DeploymentCoordinator.printUnsupportedDeviceProfileMessageBox(devData.getDevice(), null);
        }
    }

    private void queryTypes(DeviceDeploymentData devData, IDeviceManagementInteractor executor) throws DeploymentException, InterruptedException {
        for (FBTypeEntry fBTypeEntry : devData.getFbTypes()) {
            if (this.curMonitor.isCanceled()) {
                throw new InterruptedException(Messages.DeploymentCoordinator_LABEL_DownloadAborted);
            }
            executor.queryFBType(fBTypeEntry);
            this.curMonitor.worked(1);
        }
        for (DataTypeEntry dataTypeEntry : devData.getDataTypes()) {
            if (this.curMonitor.isCanceled()) {
                throw new InterruptedException(Messages.DeploymentCoordinator_LABEL_DownloadAborted);
            }
            executor.queryDataType(dataTypeEntry);
            this.curMonitor.worked(1);
        }
    }

    private void deployResources(DeviceDeploymentData devData, IDeviceManagementInteractor executor) throws InterruptedException, DeploymentException {
        Set<String> resources = executor.queryResources().stream().map(Resource::getName).collect(Collectors.toSet());
        for (ResourceDeploymentData resData : devData.getResData()) {
            if (this.curMonitor.isCanceled()) {
                throw new InterruptedException(Messages.DeploymentCoordinator_LABEL_DownloadAborted);
            }
            if (!this.checkResource(resData.getRes(), resources, executor)) continue;
            this.deployResource(resData, executor);
        }
    }

    private boolean checkResource(org.eclipse.fordiac.ide.model.libraryElement.Resource res, Set<String> resourceNames, IDeviceManagementInteractor executor) throws DeploymentException, InterruptedException {
        if (resourceNames.contains(res.getName())) {
            if (this.overrideAll) {
                executor.deleteResource(res.getName());
            } else if (this.askOverrideForResource(res)) {
                executor.deleteResource(res.getName());
            } else {
                return false;
            }
        }
        return true;
    }

    private void deployDeviceData(DeviceDeploymentData devData, IDeviceManagementInteractor executor) throws DeploymentException {
        if (!devData.getSelectedDevParams().isEmpty()) {
            Device device = devData.getDevice();
            for (VarDeclaration devVar : devData.getSelectedDevParams()) {
                String value = DeploymentHelper.getVariableValue(devVar);
                if (value != null) {
                    executor.writeDeviceParameter(device, devVar.getName(), value);
                }
                this.curMonitor.worked(1);
            }
            executor.startDevice(device);
        }
    }

    private void addDeploymentListener(IDeviceManagementInteractor executor) {
        if (this.outputView != null) {
            executor.addDeploymentListener(this.outputView);
        }
        executor.addDeploymentListener(this);
    }

    private void removeDeploymentListener(IDeviceManagementInteractor executor) {
        if (this.outputView != null) {
            executor.removeDeploymentListener(this.outputView);
        }
        executor.removeDeploymentListener(this);
    }

    private int calculateWorkAmount() {
        int retVal = this.deploymentData.size();
        for (DeviceDeploymentData devData : this.deploymentData) {
            retVal += devData.getSelectedDevParams().size();
            retVal += devData.getResData().size();
            retVal += devData.getFbTypes().size();
            retVal += devData.getDataTypes().size();
            for (ResourceDeploymentData resDepData : devData.getResData()) {
                retVal += DownloadRunnable.countResourceParams(resDepData.getRes());
                retVal += resDepData.getFbs().size() + resDepData.getConnections().size() + resDepData.getParams().size();
            }
        }
        return retVal;
    }

    private static int countResourceParams(org.eclipse.fordiac.ide.model.libraryElement.Resource res) {
        int work = 0;
        for (VarDeclaration varDecl : res.getVarDeclarations()) {
            if (varDecl.getValue() == null || varDecl.getValue().getValue().isEmpty()) continue;
            ++work;
        }
        return work;
    }

    protected void deployResource(ResourceDeploymentData resDepData, IDeviceManagementInteractor executor) throws DeploymentException {
        org.eclipse.fordiac.ide.model.libraryElement.Resource res = resDepData.getRes();
        if (!res.isDeviceTypeResource()) {
            executor.createResource(res);
            this.curMonitor.worked(1);
            for (VarDeclaration varDecl : res.getVarDeclarations()) {
                String val = DeploymentHelper.getVariableValue(varDecl);
                if (val == null) continue;
                executor.writeResourceParameter(res, varDecl.getName(), val);
                this.curMonitor.worked(1);
            }
            this.createFBInstance(resDepData, executor);
            this.deployParameters(resDepData, executor);
            this.deployConnections(resDepData, executor);
            executor.startResource(res);
        }
    }

    private void deployParameters(ResourceDeploymentData resDepData, IDeviceManagementInteractor executor) throws DeploymentException {
        for (Map.Entry<String, String> param : resDepData.getParams().entrySet()) {
            executor.writeFBParameter(resDepData.getRes(), param.getKey(), param.getValue());
            this.curMonitor.worked(1);
        }
    }

    private void deployConnections(ResourceDeploymentData resDepData, IDeviceManagementInteractor executor) throws DeploymentException {
        for (ConnectionDeploymentData con : resDepData.getConnections()) {
            executor.createConnection(resDepData.getRes(), con);
            this.curMonitor.worked(1);
            if (this.curMonitor.isCanceled()) break;
        }
    }

    private void createFBInstance(ResourceDeploymentData resDepData, IDeviceManagementInteractor executor) throws DeploymentException {
        org.eclipse.fordiac.ide.model.libraryElement.Resource res = resDepData.getRes();
        for (FBDeploymentData fbDepData : resDepData.getFbs()) {
            FB fb;
            FBNetworkElement fBNetworkElement = fbDepData.getFb();
            if (!(fBNetworkElement instanceof FB) || (fb = (FB)fBNetworkElement).isResourceTypeFB()) continue;
            executor.createFBInstance(fbDepData, res);
            this.curMonitor.worked(1);
        }
    }

    private boolean askOverrideForResource(org.eclipse.fordiac.ide.model.libraryElement.Resource res) throws InterruptedException {
        AtomicInteger result = new AtomicInteger();
        Display.getDefault().syncExec(() -> {
            Shell shell = Display.getDefault().getActiveShell();
            MessageDialog dialog = new MessageDialog(shell, Messages.DownloadRunnable_ResourceAlreadyExists, null, MessageFormat.format(Messages.DownloadRunnable_ResourceOverrideQuestion, res.getName(), res.getDevice().getName()), 3, new String[]{Messages.DownloadRunnable_Replace, SWT.getMessage((String)"SWT_Abort"), SWT.getMessage((String)"SWT_Cancel"), Messages.DownloadRunnable_ReplaceAll}, 0);
            result.set(dialog.open());
        });
        switch (result.get()) {
            case 0: {
                return true;
            }
            case 1: {
                throw new InterruptedException(Messages.DeploymentCoordinator_LABEL_DownloadAborted);
            }
            case 3: {
                this.reasureOverrideAll();
                return true;
            }
        }
        return false;
    }

    private void reasureOverrideAll() throws InterruptedException {
        StringBuilder message = new StringBuilder(Messages.DownloadRunnable_ReassureOveride);
        for (DeviceDeploymentData data : this.deploymentData) {
            message.append("\n\t- ");
            message.append(data.getDevice().getName());
            message.append(":");
            for (ResourceDeploymentData resData : data.getResData()) {
                message.append("\n\t\t- ");
                message.append(resData.getRes().getName());
            }
        }
        AtomicInteger result = new AtomicInteger();
        Display.getDefault().syncExec(() -> {
            Shell shell = Display.getDefault().getActiveShell();
            MessageDialog dialog = new MessageDialog(shell, Messages.DownloadRunnable_ReassureOverideHeader, null, message.toString(), 3, new String[]{Messages.DownloadRunnable_ReplaceAll, SWT.getMessage((String)"SWT_Abort")}, 0);
            result.set(dialog.open());
        });
        if (1 == result.get()) {
            throw new InterruptedException(Messages.DeploymentCoordinator_LABEL_DownloadAborted);
        }
        this.overrideAll = true;
    }

    @Override
    public void connectionOpened(Device dev) {
    }

    @Override
    public void postCommandSent(String info, String destination, String command) {
    }

    @Override
    public void postResponseReceived(String response, String source) {
        if (response.contains("Reason") && this.result.isOK()) {
            this.result = Status.error((String)Messages.DownloadRunnable_DeploymentErrorWarningMessage);
        }
    }

    @Override
    public void connectionClosed(Device dev) {
    }

    private void handleDeploymentException(Device device, DeploymentException e) {
        this.result = Status.error((String)MessageFormat.format(Messages.DownloadRunnable_DownloadErrorDetails, device.getName(), DeploymentHelper.getMgrIDSafe(device), e.getMessage()), (Throwable)e.getCause());
    }

    public IStatus getResult() {
        return this.result;
    }
}

