/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.persistence;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.persistence.SerializableEObjectDescriptionProvider;
import org.eclipse.xtext.resource.persistence.SerializationExtensions;

public class SerializableEObjectDescription
implements IEObjectDescription,
Externalizable,
SerializableEObjectDescriptionProvider {
    protected URI eObjectURI;
    protected EClass eClass;
    protected QualifiedName qualifiedName;
    protected HashMap<String, String> userData;
    protected transient EObject eObjectOrProxy;

    public void updateResourceURI(URI uri) {
        this.eObjectURI = uri.appendFragment(this.eObjectURI.fragment());
    }

    @Override
    public EObject getEObjectOrProxy() {
        if (this.eObjectOrProxy == null) {
            EObject proxy = EcoreUtil.create((EClass)this.eClass);
            ((InternalEObject)proxy).eSetProxyURI(this.eObjectURI);
            this.eObjectOrProxy = proxy;
        }
        return this.eObjectOrProxy;
    }

    @Override
    public QualifiedName getName() {
        return this.qualifiedName;
    }

    @Override
    public String getUserData(String key) {
        return this.userData.get(key);
    }

    @Override
    public String[] getUserDataKeys() {
        return this.userData.keySet().toArray(new String[0]);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.eObjectURI = SerializationExtensions.readURI(in);
        this.eClass = (EClass)SerializationExtensions.readEcoreElement(in);
        this.qualifiedName = SerializationExtensions.readQualifiedName(in);
        this.userData = (HashMap)SerializationExtensions.readCastedObject(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerializationExtensions.writeURI(out, this.eObjectURI);
        SerializationExtensions.writeEcoreElement(out, (ENamedElement)this.eClass);
        SerializationExtensions.writeQualifiedName(out, this.qualifiedName);
        out.writeObject(this.userData);
    }

    @Override
    public SerializableEObjectDescription toSerializableEObjectDescription() {
        return this;
    }

    @Override
    public URI getEObjectURI() {
        return this.eObjectURI;
    }

    public void setEObjectURI(URI eObjectURI) {
        this.eObjectURI = eObjectURI;
    }

    @Override
    public EClass getEClass() {
        return this.eClass;
    }

    public void setEClass(EClass eClass) {
        this.eClass = eClass;
    }

    @Override
    public QualifiedName getQualifiedName() {
        return this.qualifiedName;
    }

    public void setQualifiedName(QualifiedName qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public HashMap<String, String> getUserData() {
        return this.userData;
    }

    public void setUserData(HashMap<String, String> userData) {
        this.userData = userData;
    }
}

