/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextalgorithm.formatting2;

import com.google.inject.Inject;
import java.lang.runtime.SwitchBootstraps;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fordiac.ide.structuredtextalgorithm.services.STAlgorithmGrammarAccess;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithm;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithmPackage;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithmSource;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STMethod;
import org.eclipse.fordiac.ide.structuredtextcore.formatting2.STCoreAutowrapFormatter;
import org.eclipse.fordiac.ide.structuredtextcore.formatting2.STCoreFormatter;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STSource;
import org.eclipse.xtext.formatting2.IAutowrapFormatter;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;

public class STAlgorithmFormatter
extends STCoreFormatter {
    @Inject
    private STAlgorithmGrammarAccess grammarAccess;

    protected void _format(STAlgorithmSource source, IFormattableDocument document) {
        this.formatSource((STSource)source, document);
        source.getElements().forEach(arg_0 -> ((IFormattableDocument)document).format(arg_0));
    }

    protected void _format(STAlgorithm algorithm, IFormattableDocument document) {
        ISemanticRegion algorithmKeyword = this.textRegionExtensions.regionFor((EObject)algorithm).keyword("ALGORITHM");
        ISemanticRegion endKeyword = this.textRegionExtensions.regionFor((EObject)algorithm).keyword("END_ALGORITHM");
        document.prepend(algorithmKeyword, IHiddenRegionFormatter::noIndentation);
        document.append(algorithmKeyword, IHiddenRegionFormatter::oneSpace);
        document.append(this.textRegionExtensions.regionFor((EObject)algorithm).assignment(this.grammarAccess.getSTAlgorithmAccess().getNameAssignment_1()), it -> it.setNewLines(1, 1, 2));
        this.formatVarDeclarationBlocks(algorithm.getBody().getVarTempDeclarations(), document);
        algorithm.getBody().getStatements().forEach(arg_0 -> ((IFormattableDocument)document).format(arg_0));
        document.prepend(endKeyword, IHiddenRegionFormatter::noIndentation);
        document.append(endKeyword, it -> it.setNewLines(2, 2, 2));
    }

    protected void _format(STMethod method, IFormattableDocument document) {
        ISemanticRegion methodKeyword = this.textRegionExtensions.regionFor((EObject)method).keyword("METHOD");
        ISemanticRegion endKeyword = this.textRegionExtensions.regionFor((EObject)method).keyword("END_METHOD");
        document.prepend(methodKeyword, IHiddenRegionFormatter::noIndentation);
        document.append(methodKeyword, IHiddenRegionFormatter::oneSpace);
        if (method.getReturnType() != null) {
            ISemanticRegion colonKeyword = this.textRegionExtensions.regionFor((EObject)method).keyword(":");
            document.surround(colonKeyword, IHiddenRegionFormatter::oneSpace);
            document.prepend(colonKeyword, format -> {
                format.autowrap();
                format.setOnAutowrap((IAutowrapFormatter)new STCoreAutowrapFormatter(this.textRegionExtensions.regionFor((EObject)method).feature((EStructuralFeature)STAlgorithmPackage.Literals.ST_METHOD__RETURN_TYPE).getNextHiddenRegion()));
            });
            document.append(this.textRegionExtensions.regionFor((EObject)method).assignment(this.grammarAccess.getSTMethodAccess().getReturnTypeAssignment_2_1()), it -> it.setNewLines(1, 1, 2));
        } else {
            document.append(this.textRegionExtensions.regionFor((EObject)method).assignment(this.grammarAccess.getSTMethodAccess().getNameAssignment_1()), it -> it.setNewLines(1, 1, 2));
        }
        this.formatVarDeclarationBlocks(method.getBody().getVarDeclarations(), document);
        method.getBody().getStatements().forEach(arg_0 -> ((IFormattableDocument)document).format(arg_0));
        document.prepend(endKeyword, IHiddenRegionFormatter::noIndentation);
        document.append(endKeyword, it -> it.setNewLines(2, 2, 2));
    }

    public void format(Object object, IFormattableDocument document) {
        Object object2 = object;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{STAlgorithmSource.class, STAlgorithm.class, STMethod.class}, (Object)object2, 0)) {
            case 0: {
                STAlgorithmSource element = (STAlgorithmSource)object2;
                this._format(element, document);
                break;
            }
            case 1: {
                STAlgorithm element = (STAlgorithm)object2;
                this._format(element, document);
                break;
            }
            case 2: {
                STMethod element = (STMethod)object2;
                this._format(element, document);
                break;
            }
            default: {
                super.format(object, document);
            }
        }
    }
}

