/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.globalconstantseditor.validation;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fordiac.ide.globalconstantseditor.Messages;
import org.eclipse.fordiac.ide.globalconstantseditor.globalConstants.GlobalConstantsPackage;
import org.eclipse.fordiac.ide.globalconstantseditor.globalConstants.STGlobalConstants;
import org.eclipse.fordiac.ide.globalconstantseditor.globalConstants.STGlobalConstsSource;
import org.eclipse.fordiac.ide.globalconstantseditor.globalConstants.STVarGlobalDeclarationBlock;
import org.eclipse.fordiac.ide.globalconstantseditor.resource.GlobalConstantsResource;
import org.eclipse.fordiac.ide.globalconstantseditor.services.GlobalConstantsGrammarAccess;
import org.eclipse.fordiac.ide.globalconstantseditor.validation.AbstractGlobalConstantsValidator;
import org.eclipse.fordiac.ide.model.libraryElement.GlobalConstants;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STSource;
import org.eclipse.fordiac.ide.structuredtextcore.validation.STCoreImportValidator;
import org.eclipse.fordiac.ide.structuredtextcore.validation.STCoreTypeUsageCollector;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public class GlobalConstantsValidator
extends AbstractGlobalConstantsValidator {
    public static final String ISSUE_CODE_PREFIX = "org.eclipse.fordiac.ide.globalconstseditor.";
    public static final String GLOBAL_CONSTANTS_NAME_MISMATCH = "org.eclipse.fordiac.ide.globalconstseditor.globalConstantsNameMismatch";
    public static final String GLOBAL_VARS_NOT_MARKED_CONSTANT = "org.eclipse.fordiac.ide.globalconstseditor.globalVarsNotMarkedConstant";
    @Inject
    GlobalConstantsGrammarAccess grammarAccess;
    @Inject
    private Provider<STCoreTypeUsageCollector> typeUsageCollectorProvider;
    @Inject
    private STCoreImportValidator importValidator;

    @Check
    public void checkPackageDeclaration(STGlobalConstsSource source) {
        this.checkPackageDeclaration((STSource)source, (EStructuralFeature)GlobalConstantsPackage.Literals.ST_GLOBAL_CONSTS_SOURCE__NAME, source.getName());
    }

    @Check
    public void checkImports(STGlobalConstsSource source) {
        if (!source.getImports().isEmpty()) {
            this.importValidator.validateImports(source.getName(), (List)source.getImports(), ((STCoreTypeUsageCollector)this.typeUsageCollectorProvider.get()).collectUsedTypes((EObject)source), (ValidationMessageAcceptor)this);
        }
    }

    @Check
    public void checkGlobalConstantsMatchesTypeName(STGlobalConstants globalConstants) {
        GlobalConstants globalConstantsType;
        GlobalConstantsResource resource;
        LibraryElement libraryElement;
        Resource resource2 = globalConstants.eResource();
        if (resource2 instanceof GlobalConstantsResource && (libraryElement = (resource = (GlobalConstantsResource)resource2).getInternalLibraryElement()) instanceof GlobalConstants && !Objects.equals((globalConstantsType = (GlobalConstants)libraryElement).getName(), globalConstants.getName())) {
            this.error(MessageFormat.format(Messages.GlobalConstValidator_GlobalConstantsNameMismatch, globalConstants.getName(), globalConstantsType.getName()), (EStructuralFeature)LibraryElementPackage.Literals.INAMED_ELEMENT__NAME, GLOBAL_CONSTANTS_NAME_MISMATCH, new String[]{globalConstants.getName(), globalConstantsType.getName()});
        }
    }

    @Check
    public void checkVarConfigBlockIsMarkedConstant(STVarGlobalDeclarationBlock declarationBlock) {
        if (!declarationBlock.isConstant()) {
            ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)declarationBlock);
            for (INode n : node.getAsTreeIterable()) {
                EObject grammarElement = n.getGrammarElement();
                if (!(grammarElement instanceof Keyword) || grammarElement != this.grammarAccess.getSTVarGlobalDeclarationBlockAccess().getVAR_GLOBALKeyword_1()) continue;
                this.getMessageAcceptor().acceptError(Messages.GlobalConstValidator_GlobalConstBlockNotMarkedConstant, (EObject)declarationBlock, n.getOffset(), n.getLength(), GLOBAL_VARS_NOT_MARKED_CONSTANT, new String[0]);
            }
        }
    }
}

