/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts.helpers;

import org.eclipse.fordiac.ide.contracts.helpers.Painter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;

public class SVGPainter
implements Painter {
    private static final Color CANVAS_COLOR = new Color(240, 240, 240);
    private final StringBuilder sb = new StringBuilder();
    private Color fgCol;
    private Color bgCol;
    private double alpha = 1.0;

    public SVGPainter(Rectangle view) {
        this.sb.append("<svg viewBox=\"0 0 ");
        this.sb.append(view.width);
        this.sb.append(' ');
        this.sb.append(view.height);
        this.sb.append("\" xmlns=\"http://www.w3.org/2000/svg\">");
        this.setBackground(CANVAS_COLOR);
        this.fillRectangle(0, 0, view.width, view.height);
    }

    @Override
    public void setForeground(Color color) {
        this.fgCol = color;
    }

    @Override
    public void setBackground(Color color) {
        this.bgCol = color;
    }

    @Override
    public void setAlpha(int alpha) {
        this.alpha = (double)alpha / 255.0;
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.sb.append("<line ");
        this.addAttribute("x1", x1);
        this.addAttribute("y1", y1);
        this.addAttribute("x2", x2);
        this.addAttribute("y2", y2);
        this.addStrokeCol();
        this.sb.append("/>");
    }

    @Override
    public void drawRectangle(int x, int y, int width, int height) {
        this.sb.append("<rect ");
        this.addAttribute("x", x);
        this.addAttribute("y", y);
        this.addAttribute("width", width);
        this.addAttribute("height", height);
        this.addAttribute("fill", "none");
        this.addStrokeCol();
        this.sb.append("/>");
    }

    @Override
    public void fillRectangle(int x, int y, int width, int height) {
        this.sb.append("<rect ");
        this.addAttribute("x", x);
        this.addAttribute("y", y);
        this.addAttribute("width", width);
        this.addAttribute("height", height);
        this.addFillCol(this.bgCol);
        this.sb.append("/>");
    }

    @Override
    public void fillPolygon(int[] pointArray) {
        this.sb.append("<polygon points=\"");
        int i = 0;
        while (i + 1 < pointArray.length) {
            this.sb.append(pointArray[i]);
            this.sb.append(',');
            this.sb.append(pointArray[++i]);
            ++i;
            this.sb.append(' ');
        }
        this.sb.append("\" ");
        this.addFillCol(this.bgCol);
        this.sb.append("/>");
    }

    @Override
    public void drawTextCentered(String string, int x, int y, boolean isTransparent) {
        this.sb.append("<text ");
        this.addAttribute("x", x);
        this.addAttribute("y", y + 10);
        this.addAttribute("text-anchor", "middle");
        this.addAttribute("font-size", "12px");
        this.addFillCol(this.fgCol);
        this.sb.append(">");
        this.sb.append(string);
        this.sb.append("</text>");
    }

    public String finalizeSVG() {
        this.sb.append("</svg>");
        return this.sb.toString();
    }

    private void addAttribute(String name, Object value) {
        this.sb.append(name);
        this.sb.append("=\"");
        this.sb.append(value);
        this.sb.append("\" ");
    }

    private void addAttribute(String name, int value) {
        this.sb.append(name);
        this.sb.append("=\"");
        this.sb.append(value);
        this.sb.append("\" ");
    }

    private void addStrokeCol() {
        this.sb.append("stroke=\"");
        this.addColor(this.fgCol);
        this.sb.append("\" ");
    }

    private void addFillCol(Color color) {
        this.sb.append("fill=\"");
        this.addColor(color);
        this.sb.append("\" ");
    }

    private void addColor(Color color) {
        if (this.alpha == 1.0) {
            this.addRGB(color);
        } else {
            this.addRGBA(color, this.alpha);
        }
    }

    private void addRGB(Color color) {
        this.sb.append("rgb(");
        this.sb.append(color.getRed());
        this.sb.append(',');
        this.sb.append(color.getGreen());
        this.sb.append(',');
        this.sb.append(color.getBlue());
        this.sb.append(')');
    }

    private void addRGBA(Color color, double alpha) {
        this.sb.append("rgba(");
        this.sb.append(color.getRed());
        this.sb.append(',');
        this.sb.append(color.getGreen());
        this.sb.append(',');
        this.sb.append(color.getBlue());
        this.sb.append(',');
        this.sb.append(alpha);
        this.sb.append(')');
    }
}

