/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.fordiac.ide.contracts.CConnection;
import org.eclipse.fordiac.ide.contracts.ContractIssue;
import org.eclipse.fordiac.ide.contracts.ContractRule;
import org.eclipse.fordiac.ide.contracts.ContractSystem;
import org.eclipse.fordiac.ide.contracts.Messages;

public class ContractComponent {
    private final List<CConnection> inputs;
    private final Map<String, ContractRule> assumptions;
    private final Map<String, ContractRule> guarantees;
    private final List<ContractRule> reactions;
    private final String name;

    public ContractComponent(String name) {
        this.name = name;
        this.assumptions = new HashMap<String, ContractRule>();
        this.guarantees = new HashMap<String, ContractRule>();
        this.inputs = new ArrayList<CConnection>();
        this.reactions = new ArrayList<ContractRule>();
    }

    public List<CConnection> getInputs() {
        return this.inputs;
    }

    public void addInput(ContractComponent from, String fromPort, String toPort) {
        this.addInput(from, fromPort, toPort, CConnection.Type.NORMAL);
    }

    public void addInput(ContractComponent from, String fromPort, String toPort, CConnection.Type type) {
        this.inputs.add(new CConnection(from, fromPort, toPort, type));
    }

    public Map<String, ContractRule> getAssumptions() {
        return this.assumptions;
    }

    public Map<String, ContractRule> getGuarantees() {
        return this.guarantees;
    }

    public List<ContractRule> getReactions() {
        return this.reactions;
    }

    public String getName() {
        return this.name;
    }

    public void addRule(ContractRule rule, ContractSystem system) {
        rule.setOwner(this);
        if (rule.getType() == ContractRule.Type.SINGLE_EVENT || rule.getType() == ContractRule.Type.REPETITION) {
            this.addSingleOrRepetition(rule, system);
        } else {
            this.reactions.add(rule);
        }
    }

    private void addSingleOrRepetition(ContractRule rule, ContractSystem system) {
        if (rule.isAssumption()) {
            String input = rule.getInputs().getFirst();
            if (this.assumptions.put(input, rule) != null) {
                system.error(Messages.ContractConflictingAssumptionsError.formatted(rule.getOwner().getName(), input), ContractIssue.Code.CONFLICTING_ASSUMPTIONS);
            }
        } else {
            String output = rule.getOutputs().getFirst();
            if (this.guarantees.put(output, rule) != null) {
                system.error(Messages.ContractConflictingGuaranteesError.formatted(rule.getOwner().getName(), output), ContractIssue.Code.CONFLICTING_GUARANTEES);
            }
        }
    }
}

