/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.OutputStream;
import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.operator.PGPContentSigner;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import org.bouncycastle.openpgp.operator.bc.SignerOutputStream;
import org.bouncycastle.util.io.TeeOutputStream;

public class BcPGPContentSignerBuilder
implements PGPContentSignerBuilder {
    private BcPGPDigestCalculatorProvider digestCalculatorProvider = new BcPGPDigestCalculatorProvider();
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();
    private int hashAlgorithm;
    private SecureRandom random;
    private int keyAlgorithm;

    public BcPGPContentSignerBuilder(int n, int n2) {
        this.keyAlgorithm = n;
        this.hashAlgorithm = n2;
    }

    public BcPGPContentSignerBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    @Override
    public PGPContentSigner build(final int n, final PGPPrivateKey pGPPrivateKey) throws PGPException {
        AsymmetricKeyParameter asymmetricKeyParameter = this.keyConverter.getPrivateKey(pGPPrivateKey);
        final PGPDigestCalculator pGPDigestCalculator = this.digestCalculatorProvider.get(this.hashAlgorithm);
        final Signer signer = BcImplProvider.createSigner(this.keyAlgorithm, this.hashAlgorithm, (CipherParameters)asymmetricKeyParameter);
        if (this.random != null) {
            signer.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)asymmetricKeyParameter, this.random));
        } else {
            signer.init(true, (CipherParameters)asymmetricKeyParameter);
        }
        return new PGPContentSigner(){
            final /* synthetic */ BcPGPContentSignerBuilder this$0;
            {
                this.this$0 = bcPGPContentSignerBuilder;
            }

            @Override
            public int getType() {
                return n;
            }

            @Override
            public int getHashAlgorithm() {
                return this.this$0.hashAlgorithm;
            }

            @Override
            public int getKeyAlgorithm() {
                return this.this$0.keyAlgorithm;
            }

            @Override
            public long getKeyID() {
                return pGPPrivateKey.getKeyID();
            }

            @Override
            public OutputStream getOutputStream() {
                return new TeeOutputStream((OutputStream)new SignerOutputStream(signer), pGPDigestCalculator.getOutputStream());
            }

            @Override
            public byte[] getSignature() {
                try {
                    return signer.generateSignature();
                }
                catch (CryptoException cryptoException) {
                    throw new IllegalStateException("unable to create signature");
                }
            }

            @Override
            public byte[] getDigest() {
                return pGPDigestCalculator.getDigest();
            }
        };
    }
}

