/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.segmenter;

import com.ibm.icu.segmenter.Segments;
import com.ibm.icu.text.BreakIterator;

class BoundaryIteratorOfInts {
    private BreakIterator breakIter;
    private Segments.IterationDirection direction;
    private int currIdx;

    BoundaryIteratorOfInts(BreakIterator breakIter, CharSequence sourceSequence, Segments.IterationDirection direction, int startIdx) {
        this.breakIter = breakIter;
        this.direction = direction;
        if (direction == Segments.IterationDirection.FORWARDS) {
            this.currIdx = breakIter.following(startIdx);
        } else {
            assert (direction == Segments.IterationDirection.BACKWARDS);
            int sourceLength = sourceSequence.length();
            if (startIdx == 0) {
                this.currIdx = breakIter.first();
            } else if (startIdx == sourceLength) {
                this.currIdx = breakIter.last();
            } else {
                boolean isOnBoundary = 0 <= startIdx && startIdx <= sourceLength && breakIter.isBoundary(startIdx);
                this.currIdx = isOnBoundary ? startIdx : breakIter.preceding(startIdx);
            }
        }
    }

    public boolean hasNext() {
        return this.currIdx != -1;
    }

    public Integer next() {
        int result = this.currIdx;
        if (this.direction == Segments.IterationDirection.FORWARDS) {
            this.currIdx = this.breakIter.next();
        } else {
            assert (this.direction == Segments.IterationDirection.BACKWARDS);
            this.currIdx = this.breakIter.previous();
        }
        return result;
    }
}

