/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gitlab.management;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.fordiac.ide.gitlab.Messages;
import org.eclipse.fordiac.ide.gitlab.Package;
import org.eclipse.fordiac.ide.gitlab.Project;
import org.eclipse.fordiac.ide.gitlab.preferences.PreferenceConstants;
import org.eclipse.fordiac.ide.gitlab.treeviewer.LeafNode;
import org.eclipse.fordiac.ide.library.DownloadResult;
import org.eclipse.fordiac.ide.library.IArchiveDownloader;
import org.eclipse.fordiac.ide.library.model.util.VersionComparator;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class GitLabDownloader
implements IArchiveDownloader {
    private static final String PACKAGE_TYPE = "packageType";
    private static final String PACKAGE_VERSION = "packageVersion";
    private static final String PACKAGE_NAME = "packageName";
    private static final String PACKAGE_ID = "packageID";
    private static final String PROJECT_NAME = "projectName";
    private static final String PROJECT_ID = "projectID";
    private static final String PATH = ResourcesPlugin.getWorkspace().getRoot().getRawLocation().toPortableString();
    private static final String ROOT_DIRECTORY = ".download";
    private static final String API_VERSION = "api/v4/projects";
    private static final String PACKAGES = "/packages/";
    private static final String PACKAGE_FILES = "/package_files";
    private HashMap<Project, List<Package>> projectAndPackageMap;
    private HashMap<String, List<LeafNode>> packagesAndLeaves;
    private static final String URL_PARAMETERS = "?per_page=20";
    private static final String CUSTOM_PARAMETERS = "&membership=true";
    private static final String URL_PAGE_PARAMETER = "&page=";
    private static final String NEXT_PAGE_HEADER = "X-Next-Page";
    private final VersionComparator versionComparator;
    private String baseUrl;
    private String token;
    private boolean active;

    public GitLabDownloader() {
        this(PreferenceConstants.getToken(), PreferenceConstants.getURL());
    }

    public GitLabDownloader(String token, String baseUrl) {
        this.init(token, baseUrl);
        this.versionComparator = new VersionComparator();
        this.active = true;
    }

    public void init(String token, String baseUrl) {
        this.baseUrl = !baseUrl.isBlank() && !baseUrl.endsWith("/") ? baseUrl + "/" : baseUrl;
        this.token = token;
    }

    public Map<String, List<LeafNode>> getPackagesAndLeaves() {
        return this.packagesAndLeaves;
    }

    public Map<Project, List<Package>> getProjectsAndPackages() {
        return this.projectAndPackageMap;
    }

    public DownloadResult<Void> fetchProjectsAndPackages() {
        boolean missingToken;
        boolean missingUrl = this.baseUrl == null || this.baseUrl.isBlank();
        boolean bl = missingToken = this.token == null || this.token.isBlank();
        if (missingUrl && missingToken) {
            return new DownloadResult(DownloadResult.Status.NO_CONFIG, Messages.No_Config);
        }
        if (missingUrl || missingToken) {
            return new DownloadResult(DownloadResult.Status.CONFIG_ERROR, Messages.Configuration_Incomplete);
        }
        this.projectAndPackageMap = new HashMap();
        this.packagesAndLeaves = new HashMap();
        try {
            this.getProjects();
            for (Project project : this.projectAndPackageMap.keySet()) {
                this.getPackages(project);
            }
        }
        catch (IOException e) {
            FordiacLogHelper.logError((String)"Problem with GitLab import", (Throwable)e);
            return new DownloadResult(DownloadResult.Status.ERROR, MessageFormat.format(Messages.Download_Error, e.getMessage()));
        }
        return new DownloadResult(DownloadResult.Status.OK);
    }

    private static void createRootDir() throws IOException {
        Path path = Paths.get(PATH, ROOT_DIRECTORY);
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
    }

    private static void createPackageDir(Package p) throws IOException {
        Path path = Paths.get(PATH, ROOT_DIRECTORY, p.name() + "-" + p.version());
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
    }

    private HttpURLConnection createConnection(String target) throws IOException {
        URL url;
        try {
            url = new URI(target).toURL();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.setRequestMethod(Messages.GET);
        httpConn.setRequestProperty(Messages.Private_Token, this.token);
        return httpConn;
    }

    public Path packageDownloader(Project project, Package p, FileFilter filter) throws IOException {
        Iterator<String> iterator = this.findFilenamesInPackage(p, project, filter).iterator();
        if (iterator.hasNext()) {
            String filename = iterator.next();
            HttpURLConnection httpConn = this.createConnection(this.buildDownloadURL(p, project, filename));
            Throwable throwable = null;
            Object var8_9 = null;
            try (InputStream responseStream = httpConn.getInputStream();){
                GitLabDownloader.createRootDir();
                GitLabDownloader.createPackageDir(p);
                Files.copy(responseStream, Paths.get(PATH, ROOT_DIRECTORY, p.name() + "-" + p.version(), filename), StandardCopyOption.REPLACE_EXISTING);
                httpConn.disconnect();
                return Paths.get(PATH, ROOT_DIRECTORY, p.name() + "-" + p.version(), filename);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return null;
    }

    private List<String> findFilenamesInPackage(Package pack, Project project, FileFilter filter) throws IOException {
        HttpURLConnection httpConn = this.createConnection(this.buildPackageFileURL(pack, project));
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream responseStream = httpConn.getInputStream();){
            List<String> filenames = GitLabDownloader.parseResponse(responseStream);
            httpConn.disconnect();
            return filenames.stream().filter(filter.getPattern().asMatchPredicate()).toList();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String buildDownloadURL(Package p, Project project, String filename) {
        return this.baseUrl + "api/v4/projects/" + String.valueOf(project.id()) + PACKAGES + p.packageType() + "/" + p.name() + "/" + p.version() + "/" + filename;
    }

    private String buildPackageFileURL(Package p, Project project) {
        return this.baseUrl + "api/v4/projects/" + String.valueOf(project.id()) + PACKAGES + String.valueOf(p.id()) + PACKAGE_FILES;
    }

    private String buildConnectionURL(String page) {
        return this.baseUrl + "api/v4/projects?per_page=20&membership=true&page=" + page;
    }

    private String buildPackagesForProjectURL(Project project, String page) {
        return this.baseUrl + "api/v4/projects/" + String.valueOf(project.id()) + "/packages/?per_page=20&membership=true&page=" + page;
    }

    private void getProjects() throws IOException {
        String page = "1";
        String regex = "\\{\\\"id\\\"\\s*:\\s*(?<projectID>\\d+)\\s*,\\s*\\\"description\\\".*?,\\s*\\\"name\\\"\\s*:\\s*\\\"(?<projectName>[\\w\\s\\-\\.]+)\\\"\\s*,\\s*\\\"name_with_namespace\\\"[^\\}]*+\\}";
        Pattern p = Pattern.compile("\\{\\\"id\\\"\\s*:\\s*(?<projectID>\\d+)\\s*,\\s*\\\"description\\\".*?,\\s*\\\"name\\\"\\s*:\\s*\\\"(?<projectName>[\\w\\s\\-\\.]+)\\\"\\s*,\\s*\\\"name_with_namespace\\\"[^\\}]*+\\}");
        while (page != null && !"".equals(page)) {
            HttpURLConnection httpConn = this.createConnection(this.buildConnectionURL(page));
            Throwable throwable = null;
            Object var6_7 = null;
            try (InputStream responseStream = httpConn.getInputStream();){
                String response = "";
                Throwable throwable2 = null;
                Object var10_13 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(responseStream));){
                    response = reader.readLine();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                page = httpConn.getHeaderField(NEXT_PAGE_HEADER);
                Matcher m = p.matcher(response);
                Project project = null;
                while (m.find()) {
                    project = new Project(Long.valueOf(m.group(PROJECT_ID)), m.group(PROJECT_NAME));
                    this.projectAndPackageMap.put(project, new ArrayList());
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
    }

    private void getPackages(Project project) throws IOException {
        String page = "1";
        String regex = "(?<packageID>\\d+),\\\"name\\\":\\\"(?<packageName>[\\w\\s\\-\\.]*)\\\",\\\"version\\\":\\\"(?<packageVersion>[\\w\\s\\-\\.]*)\\\",\\\"package_type\\\":\\\"(?<packageType>[\\w\\s\\-\\.]*)";
        Pattern p = Pattern.compile("(?<packageID>\\d+),\\\"name\\\":\\\"(?<packageName>[\\w\\s\\-\\.]*)\\\",\\\"version\\\":\\\"(?<packageVersion>[\\w\\s\\-\\.]*)\\\",\\\"package_type\\\":\\\"(?<packageType>[\\w\\s\\-\\.]*)");
        while (page != null && !"".equals(page)) {
            HttpURLConnection httpConn = this.createConnection(this.buildPackagesForProjectURL(project, page));
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (InputStream responseStream = httpConn.getInputStream();){
                    String response = "";
                    Throwable throwable2 = null;
                    Object var11_15 = null;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(responseStream));){
                        response = reader.readLine();
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    page = httpConn.getHeaderField(NEXT_PAGE_HEADER);
                    Matcher m = p.matcher(response);
                    while (m.find()) {
                        Package pack = new Package(Long.valueOf(m.group(PACKAGE_ID)), m.group(PACKAGE_NAME), m.group(PACKAGE_VERSION), m.group(PACKAGE_TYPE));
                        this.projectAndPackageMap.get(project).add(pack);
                        if (!this.packagesAndLeaves.containsKey(pack.name())) {
                            this.packagesAndLeaves.put(pack.name(), new ArrayList());
                        }
                        this.packagesAndLeaves.get(pack.name()).add(new LeafNode(project, pack, pack.version()));
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                httpConn.disconnect();
                return;
            }
            httpConn.disconnect();
        }
    }

    private static List<String> parseResponse(InputStream responseStream) throws IOException {
        ArrayList<String> filenames = new ArrayList<String>();
        String response = "";
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(responseStream));){
            response = reader.readLine();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String regex = "\"file_name\":\"([^\"]*)\"";
        Pattern p = Pattern.compile("\"file_name\":\"([^\"]*)\"");
        Matcher m = p.matcher(response);
        while (m.find()) {
            filenames.add(m.group(1));
        }
        return filenames;
    }

    public String getName() {
        return this.baseUrl != null ? "Gitlab(" + this.baseUrl + ")" : "Gitlab";
    }

    public DownloadResult<List<String>> availableLibraries(IProgressMonitor monitor) throws OperationCanceledException {
        DownloadResult<Void> fetchResult = this.fetchProjectsAndPackages();
        if (fetchResult.status() != DownloadResult.Status.OK) {
            return new DownloadResult(fetchResult.status(), fetchResult.message());
        }
        return new DownloadResult(new ArrayList<String>(this.packagesAndLeaves.keySet()));
    }

    public DownloadResult<List<String>> availableVersions(String symbolicName, IProgressMonitor monitor) throws OperationCanceledException {
        DownloadResult<Void> fetchResult = this.fetchProjectsAndPackages();
        if (fetchResult.status() != DownloadResult.Status.OK) {
            return new DownloadResult(fetchResult.status(), fetchResult.message());
        }
        List<LeafNode> leaves = this.packagesAndLeaves.get(symbolicName);
        if (leaves != null) {
            return new DownloadResult(leaves.stream().map(LeafNode::getVersion).toList());
        }
        return new DownloadResult(DownloadResult.Status.NOT_FOUND, Messages.Library_Not_Found);
    }

    public DownloadResult<Path> downloadLibrary(String symbolicName, VersionRange range, Version preferredVersion, IProgressMonitor monitor) throws OperationCanceledException {
        List<LeafNode> nodes;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Downloading Library from Gitlab", (int)5);
        DownloadResult<Void> fetchResult = this.fetchProjectsAndPackages();
        progress.worked(4);
        if (fetchResult.status() != DownloadResult.Status.OK) {
            return new DownloadResult(fetchResult.status(), fetchResult.message());
        }
        if (!this.packagesAndLeaves.containsKey(symbolicName)) {
            return new DownloadResult(DownloadResult.Status.NOT_FOUND, Messages.Library_Not_Found);
        }
        Stream<Object> st = this.packagesAndLeaves.get(symbolicName).stream();
        if (range != null && !range.isEmpty()) {
            st = st.filter(l -> VersionComparator.contains((VersionRange)range, (String)l.getVersion()));
        }
        if ((nodes = st.sorted(Comparator.comparing(LeafNode::getVersion, (o1, o2) -> this.versionComparator.compare(o2, o1))).toList()).isEmpty()) {
            return new DownloadResult(DownloadResult.Status.NOT_FOUND, Messages.Version_Not_Found);
        }
        LeafNode node = null;
        if (preferredVersion != null) {
            node = nodes.stream().filter(l -> preferredVersion.compareTo(new Version(l.getVersion())) == 0).findFirst().orElse(null);
        }
        if (node == null) {
            node = nodes.getFirst();
        }
        progress.worked(1);
        try {
            return new DownloadResult((Object)this.packageDownloader(node.getProject(), node.getPackage(), FileFilter.ZIP));
        }
        catch (IOException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            return new DownloadResult(DownloadResult.Status.ERROR, MessageFormat.format(Messages.Download_Error, e.getMessage()));
        }
    }

    public DownloadResult<Path> downloadManifest(String symbolicName, Version version, IProgressMonitor monitor) throws OperationCanceledException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Downloading Manifest from Gitlab", (int)5);
        DownloadResult<Void> fetchResult = this.fetchProjectsAndPackages();
        progress.worked(4);
        if (fetchResult.status() != DownloadResult.Status.OK) {
            return new DownloadResult(fetchResult.status(), fetchResult.message());
        }
        if (!this.packagesAndLeaves.containsKey(symbolicName)) {
            return new DownloadResult(DownloadResult.Status.NOT_FOUND, Messages.Library_Not_Found);
        }
        LeafNode node = this.packagesAndLeaves.get(symbolicName).stream().filter(n -> version.toString().equals(n.getVersion())).findAny().orElse(null);
        if (node == null) {
            return new DownloadResult(DownloadResult.Status.NOT_FOUND, Messages.Version_Not_Found);
        }
        try {
            return new DownloadResult((Object)this.packageDownloader(node.getProject(), node.getPackage(), FileFilter.MANIFEST));
        }
        catch (IOException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            return new DownloadResult(DownloadResult.Status.ERROR, MessageFormat.format(Messages.Download_Error, e.getMessage()));
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public static enum FileFilter {
        ZIP(Pattern.compile(".*\\.zip")),
        MANIFEST(Pattern.compile(".*\\.MF"));

        private final Pattern pattern;

        private FileFilter(Pattern pattern) {
            this.pattern = pattern;
        }

        public Pattern getPattern() {
            return this.pattern;
        }
    }
}

