/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.resource;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.containers.IAllContainersState;

public class TypeLibraryAllContainersState
implements IAllContainersState {
    public boolean isEmpty(String containerHandle) {
        TypeLibrary typeLibrary = TypeLibraryAllContainersState.getTypeLibrary(containerHandle);
        return typeLibrary == null || typeLibrary.getAllTypes().isEmpty();
    }

    public List<String> getVisibleContainerHandles(String handle) {
        return List.of(handle);
    }

    public Collection<URI> getContainedURIs(String containerHandle) {
        TypeLibrary typeLibrary = TypeLibraryAllContainersState.getTypeLibrary(containerHandle);
        if (typeLibrary == null) {
            return Collections.emptySet();
        }
        return typeLibrary.getAllTypes().stream().map(TypeEntry::getURI).collect(Collectors.toSet());
    }

    public String getContainerHandle(URI uri) {
        TypeLibrary typeLibrary = TypeLibraryManager.INSTANCE.getTypeLibraryFromURI(uri);
        if (typeLibrary == null) {
            return null;
        }
        IProject project = typeLibrary.getProject();
        if (project == null) {
            return null;
        }
        return project.getName();
    }

    protected static TypeLibrary getTypeLibrary(String handle) {
        if (handle == null) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(handle);
        if (project == null) {
            return null;
        }
        return TypeLibraryManager.INSTANCE.getTypeLibrary(project);
    }

    public static class ProviderImpl
    implements IAllContainersState.Provider {
        public IAllContainersState get(IResourceDescriptions context) {
            return new TypeLibraryAllContainersState();
        }
    }
}

