/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands;

import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.gef.commands.Command;

public class ChangeTransitionPriorityCommand
extends Command {
    private final ECTransition transition;
    private final ECState state;
    private final boolean up;
    private final int oldStateIndex;
    private final int newStateIndex;
    private final int oldECCTransitionIndex;
    private int newECCTransitionIndex;

    public ChangeTransitionPriorityCommand(ECState state, ECTransition transition, boolean up) {
        this.transition = transition;
        this.state = state;
        this.up = up;
        this.oldStateIndex = state.getOutTransitions().indexOf((Object)transition);
        this.newStateIndex = this.oldStateIndex + (up ? -1 : 1);
        this.oldECCTransitionIndex = transition.getECC().getECTransition().indexOf((Object)transition);
    }

    public boolean canExecute() {
        return this.state.getOutTransitions().size() > 1 && (this.up && this.oldStateIndex > 0 || !this.up && this.oldStateIndex < this.state.getOutTransitions().size() - 1);
    }

    public void execute() {
        ECTransition referenceTransition = (ECTransition)this.state.getOutTransitions().get(this.newStateIndex);
        this.newECCTransitionIndex = this.transition.getECC().getECTransition().indexOf((Object)referenceTransition);
        this.redo();
    }

    public void redo() {
        this.state.getOutTransitions().move(this.newStateIndex, (Object)this.transition);
        this.transition.getECC().getECTransition().move(this.newECCTransitionIndex, (Object)this.transition);
    }

    public void undo() {
        this.state.getOutTransitions().move(this.oldStateIndex, (Object)this.transition);
        this.transition.getECC().getECTransition().move(this.oldECCTransitionIndex, (Object)this.transition);
    }
}

