/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.helper.task;

import com.google.common.base.Preconditions;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.helper.task.ModelOperationToTask;
import org.eclipse.sirius.business.internal.helper.task.operations.AbstractOperationTask;
import org.eclipse.sirius.business.internal.helper.task.operations.ForTask;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.tool.ContainerModelOperation;
import org.eclipse.sirius.viewpoint.description.tool.ModelOperation;

public class ExecuteToolOperationTask
extends AbstractCommandTask {
    private AbstractOperationTask rootOperationTask;
    private ModelAccessor extPackage;
    private UICallBack uiCallback;
    private Session session;

    public ExecuteToolOperationTask(ModelAccessor extPackage, EObject target, ModelOperation op, UICallBack uiCallback) {
        this(extPackage, target, null, op, uiCallback);
    }

    public ExecuteToolOperationTask(ModelAccessor extPackage, EObject target, DRepresentation representation, ModelOperation op, UICallBack uiCallback) {
        this.extPackage = extPackage;
        this.uiCallback = uiCallback;
        this.session = new EObjectQuery(target).getSession();
        if (this.session == null && representation != null) {
            this.session = new EObjectQuery((EObject)representation).getSession();
        }
        Preconditions.checkArgument((this.session != null ? 1 : 0) != 0, (Object)Messages.ExecuteToolOperationTask_sessionNotFound);
        CommandContext context = new CommandContext(target, representation);
        this.rootOperationTask = this.createTask(op, context);
        if (!(this.rootOperationTask instanceof ForTask) && op instanceof ContainerModelOperation) {
            this.createChildrenTasks(this.rootOperationTask, (ContainerModelOperation)op, context);
        }
        this.getChildrenTasks().add(this.rootOperationTask);
    }

    @Override
    public void execute() {
        CommandContext context = this.rootOperationTask.getContext();
        this.executeTask(this.rootOperationTask, context);
    }

    @Override
    public String getLabel() {
        return Messages.ExecuteToolOperationTask_label;
    }

    private void executeTask(ICommandTask task, CommandContext context) {
        CommandContext.pushContext(context);
        try {
            task.execute();
        }
        catch (FeatureNotFoundException | MetaClassNotFoundException e) {
            SiriusPlugin.getDefault().error(Messages.TaskExecutor_errorModifyingModelMsg, e);
        }
        if (!(task instanceof ForTask)) {
            CommandContext.pushContext(context);
            for (ICommandTask childTask : task.getChildrenTasks()) {
                this.executeTask(childTask, context);
            }
            CommandContext.popContext(context);
        }
        CommandContext.popContext(context);
    }

    private void createChildrenTasks(ICommandTask parent, ContainerModelOperation op, CommandContext context) {
        for (ModelOperation childOp : op.getSubModelOperations()) {
            AbstractOperationTask childTask = this.createTask(childOp, context);
            parent.getChildrenTasks().add(childTask);
            if (childTask instanceof ForTask || !(childOp instanceof ContainerModelOperation)) continue;
            this.createChildrenTasks(childTask, (ContainerModelOperation)childOp, context);
        }
    }

    public AbstractOperationTask createTask(ModelOperation op, CommandContext context) {
        return new ModelOperationToTask(this.extPackage, this.uiCallback, this.session, context).createTask(op);
    }

    @Override
    public boolean executeMyselfChildrenTasks() {
        return true;
    }
}

