/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.wizards;

import java.util.Objects;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.ui.editors.DataTypeTreeSelectionDialog;
import org.eclipse.fordiac.ide.model.ui.nat.DataTypeSelectionTreeContentProvider;
import org.eclipse.fordiac.ide.model.ui.nat.TypeNode;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class RepairBrokenConnectionWizardPage
extends WizardPage {
    private final TypeLibrary lib;
    private final DataType errorType;
    private StructuredType type;
    private String targetVar;

    public RepairBrokenConnectionWizardPage(TypeLibrary lib, DataType errorType) {
        super(Messages.RepairBrokenConnectionWizardPage_Title);
        this.setDescription(Messages.RepairBrokenConnectionWizardPage_Description);
        this.lib = Objects.requireNonNull(lib);
        this.errorType = Objects.requireNonNull(errorType);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData containerData = new GridData();
        containerData.horizontalAlignment = 4;
        containerData.grabExcessHorizontalSpace = true;
        container.setLayoutData((Object)containerData);
        GridLayout gridl = new GridLayout();
        gridl.numColumns = 2;
        gridl.marginWidth = 0;
        container.setLayout((Layout)gridl);
        Text currentType = new Text(container, 0x6000000);
        currentType.setText("ANY_STRUCT");
        currentType.setEditable(false);
        Button structButton = new Button(container, 0);
        structButton.setText(Messages.RepairBrokenConnectionWizardPage_Dots);
        Table varTable = new Table(container, 67588);
        varTable.setLinesVisible(true);
        varTable.setHeaderVisible(true);
        GridData tableData = new GridData();
        tableData.horizontalAlignment = 4;
        tableData.grabExcessHorizontalSpace = true;
        tableData.grabExcessVerticalSpace = true;
        tableData.heightHint = 200;
        tableData.horizontalSpan = 2;
        varTable.setLayoutData((Object)tableData);
        TableColumn column = new TableColumn(varTable, 0);
        column.setText(Messages.RepairBrokenConnectionWizardPage_Name);
        column = new TableColumn(varTable, 0);
        column.setText(Messages.RepairBrokenConnectionWizardPage_Type);
        structButton.addListener(13, event -> {
            LibraryElement libraryElement;
            TypeNode node;
            Object object;
            DataTypeSelectionTreeContentProvider instance = DataTypeSelectionTreeContentProvider.INSTANCE;
            DataTypeTreeSelectionDialog dialog = new DataTypeTreeSelectionDialog(this.getShell(), (ITreeContentProvider)instance);
            dialog.setInput((Object)this.lib);
            if (dialog.open() == 0 && (object = dialog.getFirstResult()) instanceof TypeNode && !(node = (TypeNode)object).isDirectory() && (libraryElement = node.getType()) instanceof StructuredType) {
                StructuredType structType;
                this.type = structType = (StructuredType)libraryElement;
                currentType.setText(node.getFullName());
                varTable.removeAll();
                this.type.getMemberVariables().forEach(varDec -> {
                    if (varDec.getType().equals(this.errorType)) {
                        TableItem item = new TableItem(varTable, 0);
                        item.setText(0, varDec.getName());
                        item.setText(1, varDec.getTypeName());
                    }
                    varTable.getColumn(0).pack();
                    varTable.getColumn(1).pack();
                });
                varTable.update();
            }
        });
        varTable.addListener(13, event -> {
            TableItem[] sel = varTable.getSelection();
            if (sel.length != 0 && sel[0] != null) {
                this.targetVar = sel[0].getText(0);
                this.setPageComplete(true);
            }
        });
        this.setControl((Control)container);
    }

    public boolean isPageComplete() {
        return this.type != null && this.targetVar != null;
    }

    public StructuredType getType() {
        return this.type;
    }

    public String getVar() {
        return this.targetVar;
    }
}

