/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.connection.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.change.ReconnectDataConnectionCommand;
import org.eclipse.fordiac.ide.model.commands.change.ReconnectEventConnectionCommand;
import org.eclipse.fordiac.ide.model.commands.create.EventConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.typemanagement.refactoring.connection.commands.InsertStructManipulatorCommand;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class RepairBrokenConnectionCommand
extends Command {
    private static final String STRUCT_MUX_TYPE_NAME = "STRUCT_MUX";
    private static final String STRUCT_DEMUX_TYPE_NAME = "STRUCT_DEMUX";
    private final Connection connection;
    final boolean isSourceReconnect;
    private final StructuredType structType;
    private final String varName;
    InsertStructManipulatorCommand insertMuxCommand;
    ReconnectDataConnectionCommand recon;
    CompoundCommand eventConnectionCommand;

    public RepairBrokenConnectionCommand(Connection con, boolean isSourceReconnect, StructuredType structType, String varName) {
        this.connection = Objects.requireNonNull(con);
        this.isSourceReconnect = isSourceReconnect;
        this.structType = Objects.requireNonNull(structType);
        this.varName = Objects.requireNonNull(varName);
    }

    private IInterfaceElement getPort() {
        Optional<IInterfaceElement> port = this.isSourceReconnect ? this.connection.getSourceElement().getInterface().getOutputs().filter(output -> output.getType().equals(this.structType)).findAny() : this.connection.getDestinationElement().getInterface().getInputs().filter(input -> input.getType().equals(this.structType)).findAny();
        return port.orElse(null);
    }

    private BlockFBNetworkElement getMux(IInterfaceElement port) {
        Optional<BlockFBNetworkElement> optmux = this.isSourceReconnect ? port.getOutputConnections().stream().map(Connection::getDestinationElement).filter(elem -> elem.getType().getTypeEntry().equals(port.getBlockFBNetworkElement().getTypeLibrary().getFBTypeEntry(STRUCT_DEMUX_TYPE_NAME))).findAny() : port.getInputConnections().stream().map(Connection::getSourceElement).filter(elem -> elem.getType().getTypeEntry().equals(port.getBlockFBNetworkElement().getTypeLibrary().getFBTypeEntry(STRUCT_MUX_TYPE_NAME))).findAny();
        return optmux.orElseGet(() -> {
            this.insertMuxCommand = new InsertStructManipulatorCommand(port);
            this.insertMuxCommand.execute();
            return this.insertMuxCommand.getNewElement();
        });
    }

    public boolean canExecute() {
        IInterfaceElement port = this.getPort();
        if (port != null) {
            TypeLibrary lib = port.getBlockFBNetworkElement().getTypeLibrary();
            return lib.getFBTypeEntry(STRUCT_DEMUX_TYPE_NAME) != null && lib.getFBTypeEntry(STRUCT_MUX_TYPE_NAME) != null;
        }
        return false;
    }

    public void execute() {
        IInterfaceElement eventNewTarget;
        IInterfaceElement eventReconTarget;
        Stream<Connection> connectionStream;
        FBNetwork fbn = this.connection.getFBNetwork();
        ArrayList newConList = new ArrayList();
        this.eventConnectionCommand = new CompoundCommand();
        IInterfaceElement port = this.getPort();
        if (port == null) {
            return;
        }
        BlockFBNetworkElement mux = this.getMux(port);
        Stream<Event> eventStream = ((VarDeclaration)port).getWiths().stream().map(EObject::eContainer).filter(Event.class::isInstance).map(Event.class::cast);
        if (this.isSourceReconnect) {
            connectionStream = eventStream.map(IInterfaceElement::getOutputConnections).flatMap(Collection::stream).filter(con -> this.connection.getDestinationElement().equals(con.getDestinationElement()));
            eventReconTarget = (IInterfaceElement)mux.getInterface().getEventInputs().getFirst();
            eventNewTarget = (IInterfaceElement)mux.getInterface().getEventOutputs().getFirst();
        } else {
            connectionStream = eventStream.map(IInterfaceElement::getInputConnections).flatMap(Collection::stream).filter(con -> this.connection.getSourceElement().equals(con.getSourceElement()));
            eventReconTarget = (IInterfaceElement)mux.getInterface().getEventOutputs().getFirst();
            eventNewTarget = (IInterfaceElement)mux.getInterface().getEventInputs().getFirst();
        }
        connectionStream.forEach(con -> {
            IInterfaceElement source;
            if (!RepairBrokenConnectionCommand.checkDuplicate(con, eventReconTarget)) {
                this.eventConnectionCommand.add((Command)new ReconnectEventConnectionCommand(con, !this.isSourceReconnect, eventReconTarget, fbn));
            } else {
                this.eventConnectionCommand.add((Command)new DeleteConnectionCommand(con));
            }
            IInterfaceElement iInterfaceElement3 = source = this.isSourceReconnect ? con.getDestination() : con.getSource();
            if (!RepairBrokenConnectionCommand.checkDuplicate(this.connection, eventNewTarget) && !newConList.contains(source)) {
                EventConnectionCreateCommand createECon = new EventConnectionCreateCommand(fbn);
                createECon.setSource(source);
                createECon.setDestination(eventNewTarget);
                this.eventConnectionCommand.add((Command)createECon);
                newConList.add(source);
            }
        });
        this.eventConnectionCommand.add((Command)new ReconnectDataConnectionCommand(this.connection, this.isSourceReconnect, this.isSourceReconnect ? mux.getInterface().getOutput(this.varName) : mux.getInterface().getInput(this.varName), fbn));
        this.eventConnectionCommand.execute();
    }

    private static boolean checkDuplicate(Connection connection, IInterfaceElement target) {
        if (target.isIsInput()) {
            return target.getInputConnections().stream().anyMatch(con -> con.getSource().equals(connection.getSource()));
        }
        return target.getOutputConnections().stream().anyMatch(con -> con.getDestination().equals(connection.getDestination()));
    }

    public boolean canUndo() {
        return this.eventConnectionCommand.canUndo() && (this.insertMuxCommand == null || this.insertMuxCommand.canUndo());
    }

    public void undo() {
        this.eventConnectionCommand.undo();
        if (this.insertMuxCommand != null) {
            this.insertMuxCommand.undo();
        }
    }

    public boolean canRedo() {
        return this.eventConnectionCommand.canRedo() && (this.insertMuxCommand == null || this.insertMuxCommand.canRedo());
    }

    public void redo() {
        if (this.insertMuxCommand != null) {
            this.insertMuxCommand.redo();
        }
        this.eventConnectionCommand.redo();
    }
}

