/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.widgets;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.handlers.FollowConnectionHandler;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class OppositeSelectionDialog
extends PopupDialog {
    private final List<IInterfaceElement> opposites;
    private final IInterfaceElement originPin;
    private final org.eclipse.swt.graphics.Point popupPosition;
    private final IEditorPart editor;
    private boolean allowClosing;

    public OppositeSelectionDialog(List<IInterfaceElement> opposites, IInterfaceElement originPin, Control viewerControl, IFigure popupRefFigure, IEditorPart editor) {
        super(viewerControl.getShell(), 16, true, false, false, false, false, Messages.FBPaletteViewer_SelectConnectionEnd, null);
        this.opposites = opposites;
        this.originPin = originPin;
        this.popupPosition = OppositeSelectionDialog.getPopupPosition(viewerControl, popupRefFigure);
        this.editor = editor;
        this.allowClosing = true;
    }

    private static org.eclipse.swt.graphics.Point getPopupPosition(Control viewerControl, IFigure popupRefFigure) {
        Point pinLocation = popupRefFigure.getLocation();
        pinLocation.y = (int)((float)pinLocation.y + (float)popupRefFigure.getBounds().height * 1.5f);
        popupRefFigure.translateToAbsolute((Translatable)pinLocation);
        return viewerControl.toDisplay(new org.eclipse.swt.graphics.Point(pinLocation.x, pinLocation.y));
    }

    public void setPopupClosable(boolean closeable) {
        this.allowClosing = closeable;
    }

    public boolean isCloseable() {
        return this.allowClosing;
    }

    public boolean close() {
        if (this.isCloseable()) {
            return super.close();
        }
        return false;
    }

    protected void adjustBounds() {
        super.adjustBounds();
        Rectangle rect = this.getShell().getBounds();
        rect.x = this.popupPosition.x;
        rect.y = this.popupPosition.y;
        rect.width += 6;
        rect.height += 6;
        this.getShell().setBounds(rect);
    }

    protected Control createTitleMenuArea(Composite parent) {
        Composite titleAreaComposite = (Composite)super.createTitleMenuArea(parent);
        GridData gdLabel = new GridData(4);
        gdLabel.horizontalIndent = 5;
        titleAreaComposite.setLayoutData((Object)gdLabel);
        return titleAreaComposite;
    }

    private String getPinName(IInterfaceElement iElem) {
        StringBuilder sb = new StringBuilder();
        if (iElem == null) {
            return sb.toString();
        }
        if (OppositeSelectionDialog.isInSameNetwork(this.originPin, iElem)) {
            sb.append(iElem.getBlockFBNetworkElement().getName());
        } else {
            sb.append(iElem.getBlockFBNetworkElement().getQualifiedName());
            sb.delete(0, sb.indexOf(".") + 1);
        }
        sb.append('.');
        sb.append(iElem.getName());
        return sb.toString();
    }

    private static boolean isInSameNetwork(IInterfaceElement src, IInterfaceElement dest) {
        if (src == null || dest == null) {
            return false;
        }
        BlockFBNetworkElement srcBlock = src.getBlockFBNetworkElement();
        BlockFBNetworkElement destBlock = dest.getBlockFBNetworkElement();
        if (srcBlock == null || destBlock == null) {
            return true;
        }
        return srcBlock.getFbNetwork().equals(destBlock.getFbNetwork());
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        final ListViewer listViewer = new ListViewer(dialogArea, 64);
        listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IInterfaceElement) {
                    IInterfaceElement iElem = (IInterfaceElement)element;
                    return OppositeSelectionDialog.this.getPinName(iElem);
                }
                return super.getText(element);
            }
        });
        listViewer.setInput((Object)this.opposites.toArray());
        listViewer.addSelectionChangedListener(event -> FollowConnectionHandler.selectInterfaceElement((IInterfaceElement)event.getStructuredSelection().getFirstElement(), this.editor));
        listViewer.getControl().addKeyListener((KeyListener)new FollowConnectionKeyListener(dialogArea));
        listViewer.getControl().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                OppositeSelectionDialog.this.setPopupClosable(false);
                OppositeSelectionDialog.this.getShell().getDisplay().asyncExec(() -> {
                    if (OppositeSelectionDialog.this.getShell() != null && !OppositeSelectionDialog.this.getShell().isDisposed()) {
                        listViewer.getControl().setFocus();
                    }
                });
            }

            public void focusGained(FocusEvent e) {
                OppositeSelectionDialog.this.setPopupClosable(true);
            }
        });
        GridData gd = new GridData(2);
        gd.horizontalIndent = 3;
        gd.verticalIndent = 2;
        dialogArea.setLayoutData((Object)gd);
        listViewer.setSelection((ISelection)new StructuredSelection(listViewer.getElementAt(0)), true);
        return dialogArea;
    }

    private static IHandlerService getHandlerService() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IWorkbenchPart active = page.getActivePart();
        return (IHandlerService)active.getSite().getService(IHandlerService.class);
    }

    private static void invokeFollowRightConnectionHandler() {
        try {
            OppositeSelectionDialog.getHandlerService().executeCommand("org.eclipse.fordiac.ide.application.commands.followRightConnection", null);
        }
        catch (Exception e) {
            throw new RuntimeException("followRightConnection.command not found");
        }
    }

    private static void invokeFollowLeftConnectionHandler() {
        try {
            OppositeSelectionDialog.getHandlerService().executeCommand("org.eclipse.fordiac.ide.application.commands.followLeftConnection", null);
        }
        catch (Exception e) {
            throw new RuntimeException("followLeftConnection.command not found");
        }
    }

    private class FollowConnectionKeyListener
    implements KeyListener {
        private final Composite dialogArea;

        public FollowConnectionKeyListener(Composite dialogArea) {
            this.dialogArea = dialogArea;
        }

        private void closePopup() {
            OppositeSelectionDialog.this.setPopupClosable(true);
            this.dialogArea.getShell().close();
        }

        public void keyPressed(KeyEvent e) {
            if (e.character == '\r' || e.character == '\u001b') {
                this.closePopup();
            }
            if (!OppositeSelectionDialog.this.opposites.getFirst().getInputConnections().isEmpty()) {
                this.handleRight(e);
            } else {
                this.handleLeft(e);
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        private void handleRight(KeyEvent e) {
            if (e.stateMask == 262144 && e.keyCode == 0x1000003) {
                FollowConnectionHandler.selectInterfaceElement(OppositeSelectionDialog.this.originPin, OppositeSelectionDialog.this.editor);
                this.closePopup();
            }
            if (e.stateMask == 262144 && e.keyCode == 0x1000004) {
                OppositeSelectionDialog.invokeFollowRightConnectionHandler();
                this.closePopup();
            }
        }

        private void handleLeft(KeyEvent e) {
            if (e.stateMask == 262144 && e.keyCode == 0x1000004) {
                FollowConnectionHandler.selectInterfaceElement(OppositeSelectionDialog.this.originPin, OppositeSelectionDialog.this.editor);
                this.closePopup();
            }
            if (e.stateMask == 262144 && e.keyCode == 0x1000003) {
                OppositeSelectionDialog.invokeFollowLeftConnectionHandler();
                this.closePopup();
            }
        }
    }
}

