/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.computation;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ResolvingTypeParameterHintCollector;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

public class AbstractTypeComputer {
    @Inject
    private CommonTypeComputationServices services;

    protected LightweightTypeReference getTypeForName(Class<?> clazz, ITypeComputationState state) {
        Object type = this.findDeclaredType(clazz, state);
        ITypeReferenceOwner owner = state.getReferenceOwner();
        if (type == null) {
            return owner.newUnknownTypeReference(clazz.getName());
        }
        return owner.toLightweightTypeReference((JvmType)type);
    }

    protected LightweightTypeReference getTypeForName(String clazzName, ITypeComputationState state) {
        Object type = this.findDeclaredType(clazzName, state);
        ITypeReferenceOwner owner = state.getReferenceOwner();
        if (type == null) {
            return owner.newUnknownTypeReference(clazzName);
        }
        return owner.toLightweightTypeReference((JvmType)type);
    }

    protected LightweightTypeReference getRawTypeForName(Class<?> clazz, ITypeComputationState state) {
        return state.getReferenceOwner().newReferenceTo(clazz);
    }

    protected LightweightTypeReference getRawTypeForName(String clazzName, ITypeComputationState state) {
        Object rawType = this.findDeclaredType(clazzName, state);
        if (rawType == null) {
            return state.getReferenceOwner().newUnknownTypeReference(clazzName);
        }
        return state.getReferenceOwner().toPlainTypeReference((JvmType)rawType);
    }

    @Deprecated
    protected LightweightTypeReference getRawTypeForName(Class<?> clazz, ITypeReferenceOwner owner) {
        return owner.newReferenceTo(clazz);
    }

    protected <Type extends JvmType> Type findDeclaredType(Class<?> clazz, ITypeComputationState state) {
        return this.findDeclaredType(clazz, state.getReferenceOwner());
    }

    protected <Type extends JvmType> Type findDeclaredType(String clazzName, ITypeComputationState state) {
        return this.findDeclaredType(clazzName, state.getReferenceOwner());
    }

    protected <Type extends JvmType> Type findDeclaredType(Class<?> clazz, ITypeReferenceOwner owner) {
        JvmType result = this.services.getTypeReferences().findDeclaredType(clazz, (Notifier)owner.getContextResourceSet());
        return (Type)result;
    }

    protected <Type extends JvmType> Type findDeclaredType(String clazzName, ITypeReferenceOwner owner) {
        JvmType result = this.services.getTypeReferences().findDeclaredType(clazzName, (Notifier)owner.getContextResourceSet());
        return (Type)result;
    }

    protected LightweightTypeReference getPrimitiveVoid(ITypeComputationState state) {
        return state.getReferenceOwner().newReferenceTo(Void.TYPE);
    }

    protected LightweightTypeReference getCommonSuperType(List<LightweightTypeReference> types, ITypeComputationState state) {
        return this.getCommonSuperType(types, state.getReferenceOwner());
    }

    protected LightweightTypeReference getCommonSuperType(List<LightweightTypeReference> types, ITypeReferenceOwner owner) {
        return this.services.getTypeConformanceComputer().getCommonSuperType(types, owner);
    }

    protected void deferredBindTypeArgument(LightweightTypeReference declared, LightweightTypeReference actual, ITypeComputationState state) {
        if (declared != null && actual != null) {
            ResolvingTypeParameterHintCollector collector = new ResolvingTypeParameterHintCollector(state.getReferenceOwner(), BoundTypeArgumentSource.INFERRED);
            collector.processPairedReferences(declared, actual.getWrapperTypeIfPrimitive());
        }
    }
}

