/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.util.ConfigureColumns;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.about.AboutBundleData;
import org.eclipse.ui.internal.about.AboutUtils;
import org.eclipse.ui.internal.about.BundlePatternFilter;
import org.eclipse.ui.internal.about.BundleSigningInfo;
import org.eclipse.ui.internal.about.ProductInfoPage;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.progress.WorkbenchJob;
import org.osgi.framework.Bundle;

public class AboutPluginsPage
extends ProductInfoPage {
    private static final String ID = "productInfo.plugins";
    private static final int TABLE_HEIGHT = 200;
    private static final int MORE_ID = 1025;
    private static final int SIGNING_ID = 1026;
    private static final int COLUMNS_ID = 1027;
    private static final IPath baseNLPath = IPath.fromOSString((String)"$nl$");
    private static final String PLUGININFO = "about.html";
    private static final int PLUGIN_NAME_COLUMN_INDEX = 2;
    private static final int SIGNING_AREA_PERCENTAGE = 30;
    private TableViewer vendorInfo;
    private Button moreInfo;
    private Button signingInfo;
    private String message;
    private String helpContextId = "org.eclipse.ui.about_plugins_dialog_context";
    private final String[] columnTitles = new String[]{WorkbenchMessages.AboutPluginsDialog_signed, WorkbenchMessages.AboutPluginsDialog_provider, WorkbenchMessages.AboutPluginsDialog_pluginName, WorkbenchMessages.AboutPluginsDialog_version, WorkbenchMessages.AboutPluginsDialog_pluginId};
    private Bundle[] bundles = WorkbenchPlugin.getDefault().getBundles();
    private SashForm sashForm;
    private BundleSigningInfo signingArea;

    public void setBundles(Bundle[] bundles) {
        this.bundles = bundles;
    }

    public void setHelpContextId(String id) {
        this.helpContextId = id;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    protected void handleSigningInfoPressed() {
        if (this.signingArea == null) {
            this.signingArea = new BundleSigningInfo();
            AboutBundleData bundleInfo = (AboutBundleData)this.vendorInfo.getStructuredSelection().getFirstElement();
            this.signingArea.setData(bundleInfo);
            this.signingArea.createContents((Composite)this.sashForm);
            this.sashForm.setWeights(new int[]{70, 30});
            this.signingInfo.setText(WorkbenchMessages.AboutPluginsDialog_signingInfo_hide);
        } else {
            this.signingInfo.setText(WorkbenchMessages.AboutPluginsDialog_signingInfo_show);
            this.signingArea.dispose();
            this.signingArea = null;
            this.sashForm.setWeights(new int[]{100});
        }
    }

    @Override
    public void createPageButtons(Composite parent) {
        this.moreInfo = this.createButton(parent, 1025, WorkbenchMessages.AboutPluginsDialog_moreInfo);
        this.moreInfo.setEnabled(false);
        this.signingInfo = this.createButton(parent, 1026, WorkbenchMessages.AboutPluginsDialog_signingInfo_show);
        this.signingInfo.setEnabled(false);
        this.createButton(parent, 1027, WorkbenchMessages.AboutPluginsDialog_columns);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        WorkbenchPlugin.class.getSigners();
        this.sashForm = new SashForm(parent, 65792);
        FillLayout layout = new FillLayout();
        this.sashForm.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        GridData data = new GridData(1808);
        this.sashForm.setLayoutData((Object)data);
        Composite outer = this.createOuterComposite((Composite)this.sashForm);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)outer, this.helpContextId);
        if (this.message != null) {
            Label label = new Label(outer, 0);
            label.setLayoutData((Object)new GridData(768));
            label.setFont(parent.getFont());
            label.setText(this.message);
        }
        this.createTable(outer);
        this.setControl((Control)outer);
    }

    private void calculateAboutBundleData(Consumer<Collection<AboutBundleData>> aboutBundleDataConsumer, Display display) {
        Job loadBundleDataJob = Job.create((String)WorkbenchMessages.AboutPluginsPage_Load_Bundle_Data, monitor -> {
            AboutBundleData.ExtendedSigningInfo info = (AboutBundleData.ExtendedSigningInfo)Platform.getAdapterManager().getAdapter((Object)this, AboutBundleData.ExtendedSigningInfo.class);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.bundles.length + 1));
            HashMap<String, AboutBundleData> map = new HashMap<String, AboutBundleData>();
            Bundle[] bundleArray = this.bundles;
            int n = this.bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                subMonitor.split(1);
                AboutBundleData data = new AboutBundleData(bundle, info);
                if (BundleUtility.isReady(data.getState()) && !map.containsKey(data.getVersionedId())) {
                    map.put(data.getVersionedId(), data);
                }
                ++n2;
            }
            subMonitor.split(1);
            display.asyncExec(() -> aboutBundleDataConsumer.accept(map.values()));
        });
        loadBundleDataJob.schedule();
    }

    protected void createTable(Composite parent) {
        Text filterText = new Text(parent, 2944);
        filterText.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        filterText.setMessage(WorkbenchMessages.AboutPluginsDialog_filterTextMessage);
        filterText.setFocus();
        this.vendorInfo = new TableViewer(parent, 68356);
        this.vendorInfo.setUseHashlookup(true);
        this.vendorInfo.getTable().setHeaderVisible(true);
        this.vendorInfo.getTable().setLinesVisible(true);
        this.vendorInfo.getTable().setFont(parent.getFont());
        this.vendorInfo.addSelectionChangedListener(event -> this.checkEnablement());
        TableComparator comparator = new TableComparator();
        this.vendorInfo.setComparator((ViewerComparator)comparator);
        int[] columnWidths = new int[]{this.convertHorizontalDLUsToPixels(70), this.convertHorizontalDLUsToPixels(130), this.convertHorizontalDLUsToPixels(220), this.convertHorizontalDLUsToPixels(92), this.convertHorizontalDLUsToPixels(200)};
        int i = 0;
        while (i < this.columnTitles.length) {
            TableColumn column = new TableColumn(this.vendorInfo.getTable(), 0);
            if (i == 2) {
                this.updateTableSorting(i);
            }
            column.setWidth(columnWidths[i]);
            column.setText(this.columnTitles[i]);
            int columnIndex = i++;
            column.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateTableSorting(columnIndex)));
        }
        this.vendorInfo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.vendorInfo.setLabelProvider((IBaseLabelProvider)new BundleTableLabelProvider());
        BundlePatternFilter searchFilter = new BundlePatternFilter();
        filterText.addModifyListener(e -> {
            searchFilter.setPattern(filterText.getText());
            this.vendorInfo.getTable().setRedraw(false);
            try {
                this.vendorInfo.refresh();
            }
            finally {
                this.vendorInfo.getTable().setRedraw(true);
            }
        });
        this.vendorInfo.addFilter((ViewerFilter)searchFilter);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.convertVerticalDLUsToPixels(200);
        this.vendorInfo.getTable().setLayoutData((Object)gridData);
        this.calculateAboutBundleData(bundleData -> {
            if (!this.vendorInfo.getTable().isDisposed()) {
                this.vendorInfo.setInput(bundleData);
            }
        }, parent.getDisplay());
        this.addCopySupport(this.vendorInfo.getTable());
    }

    private void updateTableSorting(int columnIndex) {
        TableComparator comparator = (TableComparator)this.vendorInfo.getComparator();
        if (columnIndex == comparator.getSortColumn()) {
            comparator.setAscending(!comparator.isAscending());
        }
        comparator.setSortColumn(columnIndex);
        this.vendorInfo.getTable().setSortColumn(this.vendorInfo.getTable().getColumn(columnIndex));
        this.vendorInfo.getTable().setSortDirection(comparator.isAscending() ? 128 : 1024);
        this.vendorInfo.refresh(false);
    }

    private URL getMoreInfoURL(AboutBundleData bundleInfo, boolean makeLocal) {
        Bundle bundle = Platform.getBundle((String)bundleInfo.getId());
        if (bundle == null) {
            return null;
        }
        URL aboutUrl = FileLocator.find((Bundle)bundle, (IPath)baseNLPath.append(PLUGININFO), null);
        if (!makeLocal) {
            return aboutUrl;
        }
        if (aboutUrl != null) {
            try {
                URL result = FileLocator.toFileURL((URL)aboutUrl);
                try {
                    URL about = new URL(aboutUrl, "about_files");
                    if (about != null) {
                        FileLocator.toFileURL((URL)about);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return result;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    String getId() {
        return ID;
    }

    private void checkEnablement() {
        IStructuredSelection selection = this.vendorInfo.getStructuredSelection();
        if (selection.getFirstElement() instanceof AboutBundleData) {
            AboutBundleData selected = (AboutBundleData)selection.getFirstElement();
            this.moreInfo.setEnabled(this.selectionHasInfo(selected));
            this.signingInfo.setEnabled(true);
            if (this.signingArea != null) {
                this.signingArea.setData(selected);
            }
        } else {
            this.signingInfo.setEnabled(false);
            this.moreInfo.setEnabled(false);
        }
    }

    @Override
    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                this.handleMoreInfoPressed();
                break;
            }
            case 1026: {
                this.handleSigningInfoPressed();
                break;
            }
            case 1027: {
                this.handleColumnsPressed();
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    private boolean selectionHasInfo(AboutBundleData bundleInfo) {
        URL infoURL = this.getMoreInfoURL(bundleInfo, false);
        if (infoURL == null && WorkbenchPlugin.DEBUG) {
            WorkbenchPlugin.log("Problem reading plugin info for: " + bundleInfo.getName());
        }
        return infoURL != null;
    }

    protected void handleMoreInfoPressed() {
        if (this.vendorInfo == null) {
            return;
        }
        if (this.vendorInfo.getSelection().isEmpty()) {
            return;
        }
        AboutBundleData bundleInfo = (AboutBundleData)this.vendorInfo.getStructuredSelection().getFirstElement();
        if (!AboutUtils.openBrowser(this.getShell(), this.getMoreInfoURL(bundleInfo, true))) {
            String message = NLS.bind((String)WorkbenchMessages.AboutPluginsDialog_unableToOpenFile, (Object)PLUGININFO, (Object)bundleInfo.getId());
            StatusUtil.handleStatus(WorkbenchMessages.AboutPluginsDialog_errorTitle + ": " + message, 2);
        }
    }

    private void handleColumnsPressed() {
        ConfigureColumns.forTable((Table)this.vendorInfo.getTable(), (IShellProvider)this);
    }

    public class BundleTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private final LinkedList<AboutBundleData> resolveQueue = new LinkedList();
        private final List<AboutBundleData> updateQueue = new ArrayList<AboutBundleData>();
        private final Job resolveJob = new Job(AboutPluginsPage.class.getName()){
            {
                this.setSystem(true);
                this.setPriority(20);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                while (((BundleTableLabelProvider)BundleTableLabelProvider.this).AboutPluginsPage.this.vendorInfo != null) {
                    Table table = ((BundleTableLabelProvider)BundleTableLabelProvider.this).AboutPluginsPage.this.vendorInfo.getTable();
                    if (table == null || table.isDisposed()) {
                        return Status.OK_STATUS;
                    }
                    AboutBundleData data = null;
                    List<AboutBundleData> list = BundleTableLabelProvider.this.resolveQueue;
                    synchronized (list) {
                        if (BundleTableLabelProvider.this.resolveQueue.isEmpty()) {
                            return Status.OK_STATUS;
                        }
                        data = BundleTableLabelProvider.this.resolveQueue.removeFirst();
                    }
                    try {
                        data.isSigned();
                        list = BundleTableLabelProvider.this.updateQueue;
                        synchronized (list) {
                            BundleTableLabelProvider.this.updateQueue.add(data);
                        }
                        BundleTableLabelProvider.this.updateJob.schedule();
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                }
                return Status.OK_STATUS;
            }
        };
        private final Job updateJob = new WorkbenchJob(PlatformUI.getWorkbench().getDisplay(), AboutPluginsPage.class.getName()){
            {
                this.setSystem(true);
                this.setPriority(50);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                Control page;
                while ((page = AboutPluginsPage.this.getControl()) != null && !page.isDisposed()) {
                    Object[] data = null;
                    List<AboutBundleData> list = BundleTableLabelProvider.this.updateQueue;
                    synchronized (list) {
                        if (BundleTableLabelProvider.this.updateQueue.isEmpty()) {
                            return Status.OK_STATUS;
                        }
                        data = BundleTableLabelProvider.this.updateQueue.toArray(new AboutBundleData[BundleTableLabelProvider.this.updateQueue.size()]);
                        BundleTableLabelProvider.this.updateQueue.clear();
                    }
                    BundleTableLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)BundleTableLabelProvider.this, data));
                }
                return Status.OK_STATUS;
            }
        };

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof AboutBundleData) {
                AboutBundleData data = (AboutBundleData)element;
                if (data.isSignedDetermined()) {
                    return WorkbenchImages.getImage(data.isSigned() ? "IMG_OBJ_SIGNED_YES" : "IMG_OBJ_SIGNED_NO");
                }
                this.resolve(data);
                return WorkbenchImages.getImage("IMG_OBJ_SIGNED_UNKNOWN");
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resolve(AboutBundleData data) {
            LinkedList<AboutBundleData> linkedList = this.resolveQueue;
            synchronized (linkedList) {
                this.resolveQueue.add(data);
            }
            this.resolveJob.schedule();
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof AboutBundleData) {
                AboutBundleData data = (AboutBundleData)element;
                switch (columnIndex) {
                    case 0: {
                        if (!data.isSignedDetermined()) {
                            return "...";
                        }
                        Date signDate = data.getSignDate();
                        if (signDate == null) break;
                        return DateFormat.getDateTimeInstance(3, 3).format(signDate);
                    }
                    case 1: {
                        return data.getProviderName();
                    }
                    case 2: {
                        return data.getName();
                    }
                    case 3: {
                        return data.getVersion();
                    }
                    case 4: {
                        return data.getId();
                    }
                }
            }
            return "";
        }
    }

    class TableComparator
    extends ViewerComparator {
        private int sortColumn = 0;
        private int lastSortColumn = 0;
        private boolean ascending = true;
        private boolean lastAscending = true;

        TableComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            TableViewer tableViewer;
            IBaseLabelProvider baseLabel;
            if (this.sortColumn == 0 && e1 instanceof AboutBundleData) {
                AboutBundleData d1 = (AboutBundleData)e1;
                if (e2 instanceof AboutBundleData) {
                    TableViewer tableViewer2;
                    IBaseLabelProvider baseLabel2;
                    AboutBundleData d2 = (AboutBundleData)e2;
                    int diff = Long.compare(this.getSignedSortValue(d1), this.getSignedSortValue(d2));
                    if (diff != 0 || this.lastSortColumn == 0) {
                        return this.ascending ? diff : -diff;
                    }
                    if (viewer instanceof TableViewer && (baseLabel2 = (tableViewer2 = (TableViewer)viewer).getLabelProvider()) instanceof ITableLabelProvider) {
                        ITableLabelProvider tableProvider = (ITableLabelProvider)baseLabel2;
                        String e1p = tableProvider.getColumnText(e1, this.lastSortColumn);
                        String e2p = tableProvider.getColumnText(e2, this.lastSortColumn);
                        int result = this.getComparator().compare(e1p, e2p);
                        return this.lastAscending ? result : -1 * result;
                    }
                    return 0;
                }
            }
            if (viewer instanceof TableViewer && (baseLabel = (tableViewer = (TableViewer)viewer).getLabelProvider()) instanceof ITableLabelProvider) {
                ITableLabelProvider tableProvider = (ITableLabelProvider)baseLabel;
                String e1p = tableProvider.getColumnText(e1, this.sortColumn);
                String e2p = tableProvider.getColumnText(e2, this.sortColumn);
                int result = this.getComparator().compare(e1p, e2p);
                if (result == 0) {
                    if (this.lastSortColumn != 0) {
                        e1p = tableProvider.getColumnText(e1, this.lastSortColumn);
                        e2p = tableProvider.getColumnText(e2, this.lastSortColumn);
                        result = this.getComparator().compare(e1p, e2p);
                        return this.lastAscending ? result : -1 * result;
                    }
                    if (e1 instanceof AboutBundleData) {
                        AboutBundleData d1 = (AboutBundleData)e1;
                        if (e2 instanceof AboutBundleData) {
                            AboutBundleData d2 = (AboutBundleData)e2;
                            int diff = Long.compare(this.getSignedSortValue(d1), this.getSignedSortValue(d2));
                            return this.lastAscending ? diff : -diff;
                        }
                    }
                }
                return this.ascending ? result : -1 * result;
            }
            return super.compare(viewer, e1, e2);
        }

        private long getSignedSortValue(AboutBundleData data) {
            if (!data.isSignedDetermined()) {
                ((BundleTableLabelProvider)AboutPluginsPage.this.vendorInfo.getLabelProvider()).resolve(data);
                return -9223372036854775807L;
            }
            Date signDate = data.getSignDate();
            if (signDate == null) {
                return Long.MIN_VALUE;
            }
            return signDate.getTime();
        }

        public int getSortColumn() {
            return this.sortColumn;
        }

        public void setSortColumn(int sortColumn) {
            if (this.sortColumn != sortColumn) {
                this.lastSortColumn = this.sortColumn;
                this.lastAscending = this.ascending;
                this.sortColumn = sortColumn;
            }
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }
    }
}

