/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.fordiac.ide.model.datatype.helper.InternalAttributeDeclarations;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.DeviceType;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.IVarElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.ResourceType;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.SegmentType;
import org.eclipse.fordiac.ide.model.libraryElement.TypedConfigureableObject;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public enum AttributeInheritMode {
    IGNORE,
    COPY,
    INHERIT,
    COPY_INHERIT;


    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static void copyAttributeValuesFromType(TypedConfigureableObject newElement) {
        void typeElement;
        if (newElement.getTypeEntry() == null) return;
        LibraryElement libraryElement = newElement.getTypeEntry().getType();
        if (!(libraryElement instanceof ConfigurableObject)) return;
        ConfigurableObject configurableObject = libraryElement;
        AttributeInheritMode.copyAttributes(newElement, typeElement.getAttributes());
        if (newElement instanceof BlockFBNetworkElement) {
            BlockFBNetworkElement fbne = (BlockFBNetworkElement)newElement;
            if (typeElement instanceof FBType) {
                FBType fbType = (FBType)typeElement;
                fbType.getInterfaceList().getAllInterfaceElements().forEach(typeInterfaceElement -> {
                    IInterfaceElement newInterface = fbne.getInterfaceElement(typeInterfaceElement.getName());
                    AttributeInheritMode.copyAttributes(newInterface, (List<Attribute>)typeInterfaceElement.getAttributes());
                });
                return;
            }
        }
        if (newElement instanceof Device) {
            Device device = (Device)newElement;
            if (typeElement instanceof DeviceType) {
                DeviceType deviceType = (DeviceType)typeElement;
                AttributeInheritMode.copyChildrenAttributeValues(device, deviceType.getVarDeclaration());
                return;
            }
        }
        if (newElement instanceof Segment) {
            Segment segment = (Segment)newElement;
            if (typeElement instanceof SegmentType) {
                SegmentType segmentType = (SegmentType)typeElement;
                AttributeInheritMode.copyChildrenAttributeValues(segment, segmentType.getVarDeclaration());
                return;
            }
        }
        if (!(newElement instanceof Resource)) return;
        Resource resource = (Resource)newElement;
        if (!(typeElement instanceof ResourceType)) return;
        ResourceType resourceType = (ResourceType)typeElement;
        AttributeInheritMode.copyChildrenAttributeValues(resource, resourceType.getVarDeclaration());
    }

    private static void copyChildrenAttributeValues(IVarElement newElement, List<VarDeclaration> typeDeclarations) {
        typeDeclarations.forEach(typeVarDecl -> newElement.getVarDeclarations().stream().filter(instanceDecl -> instanceDecl.getName().equals(typeVarDecl.getName())).findFirst().ifPresent(newDecl -> AttributeInheritMode.copyAttributes(newDecl, (List<Attribute>)typeVarDecl.getAttributes())));
    }

    private static void copyAttributes(ConfigurableObject conf, List<Attribute> attributes) {
        attributes.forEach(attribute -> {
            if (AttributeInheritMode.hasDeclarationWithInheritMode(attribute, Set.of(COPY, COPY_INHERIT))) {
                conf.setAttribute(attribute.getAttributeDeclaration(), attribute.getValue(), attribute.getComment());
            }
        });
    }

    public static List<Attribute> getInheritAttributes(ConfigurableObject instance, List<Attribute> typeAttributes) {
        List<AttributeDeclaration> instanceDeclarationList = instance.getAttributes().stream().map(Attribute::getAttributeDeclaration).filter(Objects::nonNull).toList();
        return typeAttributes.stream().filter(attribute -> AttributeInheritMode.hasDeclarationWithInheritMode(attribute, Set.of(INHERIT, COPY_INHERIT))).filter(attribute -> !instanceDeclarationList.contains(attribute.getAttributeDeclaration())).toList();
    }

    private static boolean hasDeclarationWithInheritMode(Attribute attribute, Set<AttributeInheritMode> modes) {
        Attribute declarationsInheritAttibute;
        Attribute attribute2;
        return attribute.getAttributeDeclaration() != null && (attribute2 = attribute.getAttributeDeclaration().getAttribute(InternalAttributeDeclarations.INHERIT.getName())) instanceof Attribute && modes.contains((Object)AttributeInheritMode.valueOf((declarationsInheritAttibute = attribute2).getValue()));
    }
}

