/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editors;

import java.util.function.Consumer;
import org.eclipse.fordiac.ide.structuredtextalgorithm.ui.editor.embedded.STAlgorithmEmbeddedEditorUtil;
import org.eclipse.fordiac.ide.ui.providers.SourceViewerColorProvider;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;

public abstract class XtextEmbeddedFieldEditor {
    private StyledText control;
    private EmbeddedEditor embeddedEditor;
    private EmbeddedEditorModelAccess modelAccess;
    private boolean proposalPopupOpen;
    private Consumer<Command> commandExecutor;

    protected XtextEmbeddedFieldEditor(Composite parent, int style) {
        this.createControl(parent, style);
    }

    protected void createControl(final Composite parent, int style) {
        IEditedResourceProvider editedResourceProvider = this.createEditedResourceProvider();
        this.embeddedEditor = STAlgorithmEmbeddedEditorUtil.getEmbeddedEditorFactory().newEditor(editedResourceProvider).withStyle(style).withParent(parent);
        this.modelAccess = this.embeddedEditor.createPartialEditor();
        this.embeddedEditor.getViewer().setEditable(false);
        SourceViewerColorProvider.initializeSourceViewerColors((ISourceViewer)this.embeddedEditor.getViewer());
        this.embeddedEditor.getViewer().getContentAssistantFacade().addCompletionListener(new ICompletionListener(){

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
            }

            public void assistSessionStarted(ContentAssistEvent event) {
                XtextEmbeddedFieldEditor.this.proposalPopupOpen = true;
            }

            public void assistSessionEnded(ContentAssistEvent event) {
                XtextEmbeddedFieldEditor.this.proposalPopupOpen = false;
            }
        });
        this.control = (StyledText)this.embeddedEditor.getViewer().getControl();
        this.control.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                parent.getDisplay().asyncExec(() -> {
                    if (!XtextEmbeddedFieldEditor.this.control.isDisposed()) {
                        XtextEmbeddedFieldEditor.this.control.setSelection(0, XtextEmbeddedFieldEditor.this.control.getText().length());
                    }
                });
            }

            public void focusLost(FocusEvent e) {
                if (!XtextEmbeddedFieldEditor.this.isProposalPopupOpen()) {
                    XtextEmbeddedFieldEditor.this.commit();
                }
            }
        });
        this.control.addVerifyKeyListener(event -> {
            if (event.doit && !this.isProposalPopupOpen()) {
                if ((event.keyCode == 13 || event.keyCode == 0x1000050) && event.stateMask != SWT.MOD3) {
                    parent.forceFocus();
                    event.doit = false;
                } else if (event.keyCode == 27 && event.stateMask == 0) {
                    Consumer<Command> commandExecutorCache = this.commandExecutor;
                    this.commandExecutor = null;
                    parent.forceFocus();
                    this.commandExecutor = commandExecutorCache;
                    event.doit = false;
                }
            }
        });
    }

    protected abstract IEditedResourceProvider createEditedResourceProvider();

    public abstract void commit();

    public abstract void refresh();

    protected EmbeddedEditor getEmbeddedEditor() {
        return this.embeddedEditor;
    }

    protected EmbeddedEditorModelAccess getModelAccess() {
        return this.modelAccess;
    }

    protected boolean isProposalPopupOpen() {
        return this.proposalPopupOpen;
    }

    public void executeCommand(Command command) {
        if (this.commandExecutor != null) {
            this.commandExecutor.accept(command);
        }
    }

    public Consumer<Command> getCommandExecutor() {
        return this.commandExecutor;
    }

    public void setCommandExecutor(Consumer<Command> commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public boolean isEditable() {
        return this.embeddedEditor.getViewer().isEditable();
    }

    public void setEditable(boolean editable) {
        this.embeddedEditor.getViewer().setEditable(editable);
    }

    public StyledText getControl() {
        return this.control;
    }
}

