/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.util;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.eclipse.elk.graph.EMapPropertyHolder;
import org.eclipse.elk.graph.ElkBendPoint;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkGraphFactory;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.properties.AdvancedPropertyValue;
import org.eclipse.elk.graph.properties.ExperimentalPropertyValue;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;

public final class ElkGraphUtil {
    public static ElkNode createGraph() {
        return ElkGraphUtil.createNode(null);
    }

    public static ElkNode createNode(ElkNode parent) {
        ElkNode node = ElkGraphFactory.eINSTANCE.createElkNode();
        if (parent != null) {
            node.setParent(parent);
        }
        return node;
    }

    public static ElkPort createPort(ElkNode parent) {
        ElkPort port = ElkGraphFactory.eINSTANCE.createElkPort();
        if (parent != null) {
            port.setParent(parent);
        }
        return port;
    }

    public static ElkLabel createLabel(ElkGraphElement parent) {
        ElkLabel label = ElkGraphFactory.eINSTANCE.createElkLabel();
        if (parent != null) {
            label.setParent(parent);
        }
        return label;
    }

    public static ElkLabel createLabel(String text, ElkGraphElement parent) {
        ElkLabel label = ElkGraphUtil.createLabel(parent);
        label.setText(text);
        return label;
    }

    public static ElkEdge createEdge(ElkNode containingNode) {
        ElkEdge edge = ElkGraphFactory.eINSTANCE.createElkEdge();
        if (containingNode != null) {
            edge.setContainingNode(containingNode);
        }
        return edge;
    }

    public static ElkEdge createSimpleEdge(ElkConnectableShape source, ElkConnectableShape target) {
        Objects.requireNonNull(source, "source cannot be null");
        Objects.requireNonNull(target, "target cannot be null");
        ElkEdge edge = ElkGraphUtil.createEdge(null);
        edge.getSources().add((Object)source);
        edge.getTargets().add((Object)target);
        ElkGraphUtil.updateContainment(edge);
        return edge;
    }

    public static ElkEdge createHyperedge(Iterable<ElkConnectableShape> sources, Iterable<ElkConnectableShape> targets) {
        Objects.requireNonNull(sources, "sources cannot be null");
        Objects.requireNonNull(targets, "targets cannot be null");
        ElkEdge edge = ElkGraphUtil.createEdge(null);
        EList<ElkConnectableShape> edgeSources = edge.getSources();
        for (ElkConnectableShape source : sources) {
            edgeSources.add(source);
        }
        EList<ElkConnectableShape> edgeTargets = edge.getTargets();
        for (ElkConnectableShape target : targets) {
            edgeTargets.add(target);
        }
        ElkGraphUtil.updateContainment(edge);
        return edge;
    }

    public static ElkEdgeSection createEdgeSection(ElkEdge edge) {
        ElkEdgeSection section = ElkGraphFactory.eINSTANCE.createElkEdgeSection();
        if (edge != null) {
            edge.getSections().add((Object)section);
        }
        return section;
    }

    public static ElkEdgeSection firstEdgeSection(ElkEdge edge, boolean resetSection, boolean removeOtherSections) {
        if (edge.getSections().isEmpty()) {
            return ElkGraphUtil.createEdgeSection(edge);
        }
        ElkEdgeSection section = (ElkEdgeSection)edge.getSections().get(0);
        if (resetSection) {
            section.getBendPoints().clear();
            section.setStartLocation(0.0, 0.0);
            section.setEndLocation(0.0, 0.0);
        }
        if (removeOtherSections) {
            EList<ElkEdgeSection> sections = edge.getSections();
            while (sections.size() > 1) {
                sections.remove(sections.size() - 1);
            }
        }
        return section;
    }

    public static ElkBendPoint createBendPoint(ElkEdgeSection edgeSection) {
        return ElkGraphUtil.createBendPoint(edgeSection, 0.0, 0.0);
    }

    public static ElkBendPoint createBendPoint(ElkEdgeSection edgeSection, double x, double y) {
        ElkBendPoint bendPoint = ElkGraphFactory.eINSTANCE.createElkBendPoint();
        bendPoint.set(x, y);
        if (edgeSection != null) {
            edgeSection.getBendPoints().add((Object)bendPoint);
        }
        return bendPoint;
    }

    public static void updateContainment(ElkEdge edge) {
        Objects.requireNonNull(edge, "edge cannot be null");
        edge.setContainingNode(ElkGraphUtil.findBestEdgeContainment(edge));
    }

    public static ElkNode findBestEdgeContainment(ElkEdge edge) {
        Objects.requireNonNull(edge, "edge cannot be null");
        switch (edge.getSources().size() + edge.getTargets().size()) {
            case 0: {
                throw new IllegalArgumentException("The edge must have at least one source or target.");
            }
            case 1: {
                if (edge.getSources().isEmpty()) {
                    return ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)edge.getTargets().get(0)).getParent();
                }
                return ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)edge.getSources().get(0)).getParent();
            }
        }
        if (edge.getSources().size() == 1 && edge.getTargets().size() == 1) {
            ElkNode sourceNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)edge.getSources().get(0));
            ElkNode targetNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)edge.getTargets().get(0));
            if (sourceNode.getParent() == targetNode.getParent()) {
                return sourceNode.getParent();
            }
            if (sourceNode == targetNode.getParent()) {
                return sourceNode;
            }
            if (targetNode == sourceNode.getParent()) {
                return targetNode;
            }
        }
        Iterator<ElkConnectableShape> incidentShapes = ElkGraphUtil.allIncidentShapes(edge).iterator();
        ElkNode commonAncestor = ElkGraphUtil.connectableShapeToNode(incidentShapes.next());
        while (incidentShapes.hasNext()) {
            ElkNode incidentNode = ElkGraphUtil.connectableShapeToNode(incidentShapes.next());
            if (incidentNode == commonAncestor || ElkGraphUtil.isDescendant(incidentNode, commonAncestor)) continue;
            if (incidentNode.getParent() == commonAncestor.getParent()) {
                commonAncestor = incidentNode.getParent();
                continue;
            }
            if ((commonAncestor = ElkGraphUtil.findLowestCommonAncestor(commonAncestor, incidentNode)) != null) continue;
            return null;
        }
        return commonAncestor;
    }

    public static ElkNode findLowestCommonAncestor(ElkNode node1, ElkNode node2) {
        ArrayList ancestors1 = Lists.newArrayList((Iterator)new AncestorIterator(node1, true));
        ListIterator iterator1 = ancestors1.listIterator(ancestors1.size());
        ArrayList ancestors2 = Lists.newArrayList((Iterator)new AncestorIterator(node2, true));
        ListIterator iterator2 = ancestors2.listIterator(ancestors2.size());
        ElkNode commonAncestor = null;
        while (iterator1.hasPrevious() && iterator2.hasPrevious()) {
            ElkNode ancestor2;
            ElkNode ancestor1 = (ElkNode)iterator1.previous();
            if (ancestor1 != (ancestor2 = (ElkNode)iterator2.previous())) break;
            commonAncestor = ancestor1;
        }
        return commonAncestor;
    }

    public static Iterable<ElkEdge> allIncomingEdges(ElkNode node) {
        ArrayList incomingEdgeIterables = Lists.newArrayListWithCapacity((int)(1 + node.getPorts().size()));
        incomingEdgeIterables.add(node.getIncomingEdges());
        for (ElkPort port : node.getPorts()) {
            incomingEdgeIterables.add(port.getIncomingEdges());
        }
        return Iterables.concat((Iterable)incomingEdgeIterables);
    }

    public static Iterable<ElkEdge> allOutgoingEdges(ElkNode node) {
        ArrayList outgoingEdgeIterables = Lists.newArrayListWithCapacity((int)(1 + node.getPorts().size()));
        outgoingEdgeIterables.add(node.getOutgoingEdges());
        for (ElkPort port : node.getPorts()) {
            outgoingEdgeIterables.add(port.getOutgoingEdges());
        }
        return Iterables.concat((Iterable)outgoingEdgeIterables);
    }

    public static Iterable<ElkEdge> allIncidentEdges(ElkConnectableShape shape) {
        return Iterables.concat(shape.getIncomingEdges(), shape.getOutgoingEdges());
    }

    public static Iterable<ElkEdge> allIncidentEdges(ElkNode node) {
        return Iterables.concat(ElkGraphUtil.allOutgoingEdges(node), ElkGraphUtil.allIncomingEdges(node));
    }

    public static Iterable<ElkConnectableShape> allIncidentShapes(ElkEdge edge) {
        return Iterables.concat(edge.getSources(), edge.getTargets());
    }

    public static Iterable<ElkEdgeSection> allIncidentSections(ElkEdgeSection section) {
        return Iterables.concat(section.getIncomingSections(), section.getOutgoingSections());
    }

    public static boolean isDescendant(ElkNode child, ElkNode ancestor) {
        ElkNode current = child;
        while (current.getParent() != null) {
            if ((current = current.getParent()) != ancestor) continue;
            return true;
        }
        return false;
    }

    public static ElkNode containingGraph(ElkGraphElement element) {
        for (ElkGraphElement current = element; current != null; current = (ElkGraphElement)current.eContainer()) {
            if (current instanceof ElkEdge) {
                return ((ElkEdge)current).getContainingNode();
            }
            if (current instanceof ElkNode) {
                return ((ElkNode)current).getParent();
            }
            if (current.eContainer() instanceof ElkGraphElement) {
                continue;
            }
            return null;
        }
        return null;
    }

    public static ElkNode connectableShapeToNode(ElkConnectableShape connectableShape) {
        if (connectableShape instanceof ElkNode) {
            return (ElkNode)connectableShape;
        }
        if (connectableShape instanceof ElkPort) {
            return ((ElkPort)connectableShape).getParent();
        }
        if (connectableShape == null) {
            throw new NullPointerException("connectableShape cannot be null");
        }
        throw new UnsupportedOperationException("Only support nodes and ports.");
    }

    public static ElkPort connectableShapeToPort(ElkConnectableShape connectableShape) {
        if (connectableShape instanceof ElkPort) {
            return (ElkPort)connectableShape;
        }
        if (connectableShape == null) {
            throw new NullPointerException("connectableShape cannot be null");
        }
        return null;
    }

    public static ElkNode getSourceNode(ElkEdge simpleEdge) {
        if (simpleEdge.getSources().size() != 1 || simpleEdge.getTargets().size() != 1) {
            throw new IllegalArgumentException("Passed edge is not 'simple'.");
        }
        return ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)simpleEdge.getSources().get(0));
    }

    public static ElkNode getTargetNode(ElkEdge simpleEdge) {
        if (simpleEdge.getSources().size() != 1 || simpleEdge.getTargets().size() != 1) {
            throw new IllegalArgumentException("Passed edge is not 'simple'.");
        }
        return ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)simpleEdge.getTargets().get(0));
    }

    public static ElkPort getSourcePort(ElkEdge simpleEdge) {
        if (simpleEdge.getSources().size() != 1 || simpleEdge.getTargets().size() != 1) {
            throw new IllegalArgumentException("Passed edge is not 'simple'.");
        }
        return ElkGraphUtil.connectableShapeToPort((ElkConnectableShape)simpleEdge.getSources().get(0));
    }

    public static ElkPort getTargetPort(ElkEdge simpleEdge) {
        if (simpleEdge.getSources().size() != 1 || simpleEdge.getTargets().size() != 1) {
            throw new IllegalArgumentException("Passed edge is not 'simple'.");
        }
        return ElkGraphUtil.connectableShapeToPort((ElkConnectableShape)simpleEdge.getTargets().get(0));
    }

    public static ElkGraphElement elementLabeledBy(ElkLabel label) {
        ElkGraphElement element = label.getParent();
        while (element instanceof ElkLabel) {
            element = element.eContainer();
        }
        return element instanceof ElkGraphElement ? element : null;
    }

    public static Iterator<EObject> propertiesSkippingIteratorFor(EObject root, boolean includeRoot) {
        return new PropertiesSkippingTreeIterator(root, includeRoot);
    }

    public static boolean isAdvancedPropertyValue(Enum<?> enumValue) {
        if (enumValue != null) {
            try {
                Annotation[] annotations = enumValue.getClass().getField(enumValue.name()).getAnnotations();
                return Arrays.stream(annotations).anyMatch(a -> a instanceof AdvancedPropertyValue);
            }
            catch (NoSuchFieldException | SecurityException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isExperimentalPropertyValue(Enum<?> enumValue) {
        if (enumValue != null) {
            try {
                Annotation[] annotations = enumValue.getClass().getField(enumValue.name()).getAnnotations();
                return Arrays.stream(annotations).anyMatch(a -> a instanceof ExperimentalPropertyValue);
            }
            catch (NoSuchFieldException | SecurityException e) {
                return false;
            }
        }
        return false;
    }

    private ElkGraphUtil() {
    }

    private static class AncestorIterator
    implements Iterator<ElkNode> {
        private ElkNode nextNode;

        AncestorIterator(ElkNode startNode, boolean includeNode) {
            this.nextNode = includeNode ? startNode : startNode.getParent();
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public ElkNode next() {
            if (this.nextNode == null) {
                throw new NoSuchElementException("There is no more element.");
            }
            ElkNode next = this.nextNode;
            this.nextNode = this.nextNode.getParent();
            return next;
        }
    }

    private static class PropertiesSkippingTreeIterator
    extends AbstractTreeIterator<EObject> {
        private static final long serialVersionUID = 1L;

        PropertiesSkippingTreeIterator(Object object, boolean includeRoot) {
            super(object, includeRoot);
        }

        protected Iterator<EObject> getChildren(Object object) {
            Iterator iterator = ((EObject)object).eContents().iterator();
            if (iterator instanceof EContentsEList.FeatureIteratorImpl) {
                ((EContentsEList.FeatureIteratorImpl)iterator).filter(new EContentsEList.FeatureFilter(){

                    public boolean isIncluded(EStructuralFeature eStructuralFeature) {
                        if (eStructuralFeature.getContainerClass().equals(EMapPropertyHolder.class)) {
                            return eStructuralFeature.getFeatureID() != 0;
                        }
                        return true;
                    }
                });
            }
            return iterator;
        }
    }
}

