/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.TypeImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.GlobalConstants;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.OriginalSource;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;

public class GlobalConstantsImporter
extends TypeImporter {
    public GlobalConstantsImporter(IFile typeFile) {
        super(typeFile);
    }

    public GlobalConstantsImporter(InputStream inputStream, TypeLibrary typeLibrary) {
        super(inputStream, typeLibrary);
    }

    @Override
    protected GlobalConstants createRootModelElement() {
        return LibraryElementFactory.eINSTANCE.createGlobalConstants();
    }

    @Override
    protected String getStartElementName() {
        return "GlobalConstants";
    }

    @Override
    protected CommonElementImporter.IChildHandler getBaseChildrenHandler() {
        return name -> {
            switch (name) {
                case "Identification": {
                    this.parseIdentification(this.getElement());
                    break;
                }
                case "VersionInfo": {
                    this.parseVersionInfo(this.getElement());
                    break;
                }
                case "CompilerInfo": {
                    this.getElement().setCompilerInfo(this.parseCompilerInfo());
                    break;
                }
                case "GlobalConstants": {
                    this.parseGlobalConstants(this.getElement());
                    break;
                }
                case "OriginalSource": {
                    this.getElement().setSource(this.parseOriginalSource());
                    break;
                }
                case "Attribute": {
                    this.parseGenericAttributeNode(this.getElement());
                    this.proceedToEndElementNamed("Attribute");
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        };
    }

    private void parseGlobalConstants(GlobalConstants globalConstants) throws TypeImportException, XMLStreamException {
        this.processChildren("GlobalConstants", name -> {
            if ("VarDeclaration".equals(name)) {
                globalConstants.getConstants().add((Object)this.parseVarDeclaration());
                return true;
            }
            return false;
        });
    }

    private OriginalSource parseOriginalSource() throws XMLStreamException {
        OriginalSource source = LibraryElementFactory.eINSTANCE.createOriginalSource();
        this.parseOriginalSourceText(source);
        this.proceedToEndElementNamed("OriginalSource");
        return source;
    }

    private void parseOriginalSourceText(OriginalSource source) throws XMLStreamException {
        String text = this.getAttributeValue("Text");
        if (text != null) {
            source.setText(text);
        } else {
            source.setText(this.readCDataSection());
        }
    }

    @Override
    public GlobalConstants getElement() {
        return (GlobalConstants)super.getElement();
    }
}

