/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentStreamMonitor;
import org.eclipse.fordiac.ide.deployment.debug.Messages;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.util.IDeploymentListener2;
import org.eclipse.fordiac.ide.model.libraryElement.Device;

public class DeploymentStreamsProxy
implements IStreamsProxy,
IDeploymentListener2 {
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private final DeploymentStreamMonitor outputStreamMonitor = new DeploymentStreamMonitor();
    private final DeploymentStreamMonitor errorStreamMonitor = new DeploymentStreamMonitor();
    private final Transformer transformer;
    private String currentDest;
    private int count;

    static {
        TRANSFORMER_FACTORY.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        TRANSFORMER_FACTORY.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
    }

    public DeploymentStreamsProxy() throws DeploymentException {
        try {
            this.transformer = TRANSFORMER_FACTORY.newTransformer();
            this.transformer.setOutputProperty("indent", "yes");
            this.transformer.setOutputProperty("omit-xml-declaration", "yes");
            this.transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
    }

    public DeploymentStreamMonitor getErrorStreamMonitor() {
        return this.errorStreamMonitor;
    }

    public DeploymentStreamMonitor getOutputStreamMonitor() {
        return this.outputStreamMonitor;
    }

    public void write(String input) throws IOException {
    }

    public void connectionOpened(Device dev) {
        this.currentDest = null;
        this.outputStreamMonitor.message(MessageFormat.format(Messages.DeploymentStreamsProxy_ConnectedToDevice, dev.getName()));
    }

    public void postCommandSent(String info, String destination, String command) {
        if (destination != null && !destination.isEmpty() && !destination.isBlank()) {
            if (!destination.equals(this.currentDest)) {
                if (this.currentDest != null && !this.currentDest.isBlank()) {
                    this.printDeployStatistics();
                }
                this.printDeployingResource(destination);
                this.currentDest = destination;
                this.count = 1;
            } else {
                ++this.count;
            }
        }
    }

    private void printDeployStatistics() {
        this.outputStreamMonitor.message(MessageFormat.format(Messages.DeploymentStreamsProxy_DeployedElements, this.currentDest, this.count));
    }

    private void printDeployingResource(String destination) {
        this.outputStreamMonitor.message(MessageFormat.format(Messages.DeploymentStreamsProxy_Deploying, destination));
    }

    public void postResponseReceived(String response, String source) {
    }

    public void postResponseReceived(String info, String request, String response, String peer) {
        if (response.contains("Reason")) {
            StringBuilder requestBuffer = new StringBuilder();
            requestBuffer.append("<!-- ");
            requestBuffer.append(info);
            requestBuffer.append(" -->\n");
            requestBuffer.append(this.getFormattedXML(request));
            requestBuffer.append("\n");
            this.outputStreamMonitor.message(requestBuffer.toString());
            StringBuilder responseBuffer = new StringBuilder();
            responseBuffer.append(this.getFormattedXML(response));
            responseBuffer.append("\n\n");
            this.errorStreamMonitor.message(responseBuffer.toString());
        }
    }

    public void connectionClosed(Device dev) {
        if (this.currentDest != null && !this.currentDest.isBlank()) {
            this.printDeployStatistics();
        }
        this.outputStreamMonitor.message(MessageFormat.format(Messages.DeploymentStreamsProxy_DisconnectedFromDevice, dev.getName()));
    }

    private String getFormattedXML(String input) throws TransformerFactoryConfigurationError {
        try {
            StringReader reader = new StringReader(input);
            StringWriter writer = new StringWriter();
            this.transformer.transform(new StreamSource(reader), new StreamResult(writer));
            return writer.toString();
        }
        catch (Exception e) {
            return input;
        }
    }
}

