/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.figures;

import java.util.function.Predicate;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.gef.draw2d.ConnectorBorder;
import org.eclipse.fordiac.ide.model.libraryElement.HiddenElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;

public class UntypedSubappConnectorBorder
extends ConnectorBorder {
    private boolean secondPaint;

    public UntypedSubappConnectorBorder(IInterfaceElement editPartModelOject) {
        super(editPartModelOject);
    }

    private SubApp getSubapp() {
        return (SubApp)this.getEditPartModelOject().getBlockFBNetworkElement();
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        if (!this.getSubapp().isUnfolded() || !this.allOutsideConnectionsAreHidden()) {
            super.paint(figure, graphics, insets);
        }
        if (this.getSubapp().isUnfolded()) {
            this.secondPaint = true;
            super.paint(figure, graphics, insets);
            this.secondPaint = false;
            if (!this.isInput() && this.getEditPartModelOject().getOutputConnections().stream().filter(Predicate.not(HiddenElement::isVisible)).count() > 1L) {
                Rectangle where = UntypedSubappConnectorBorder.getPaintRectangle((IFigure)figure, (Insets)insets);
                graphics.setLineWidth(2);
                graphics.drawLine(where.x + 1, where.y + 3, where.x + 1, where.y + where.height - 3);
            }
        }
    }

    public Insets getInsets(IFigure figure) {
        if (this.getSubapp().isUnfolded()) {
            int lrMargin = this.getLRMargin();
            if (this.allOutsideConnectionsAreHidden()) {
                if (this.isInput()) {
                    return new Insets(0, 0, 0, lrMargin);
                }
                return new Insets(0, lrMargin, 0, 0);
            }
            return new Insets(0, lrMargin, 0, lrMargin);
        }
        return super.getInsets(figure);
    }

    public boolean isInput() {
        boolean input = super.isInput();
        return this.secondPaint ? !input : input;
    }

    private boolean allOutsideConnectionsAreHidden() {
        EList conList;
        EList eList = conList = this.isInput() ? this.getEditPartModelOject().getInputConnections() : this.getEditPartModelOject().getOutputConnections();
        return !conList.isEmpty() && conList.stream().allMatch(Predicate.not(HiddenElement::isVisible));
    }
}

