/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.FBTypeEditor;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.IFBTEditorPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.ServiceInterfacePaletteFactory;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.CreateServiceSequenceCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.InputPrimitiveEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.OutputPrimitiveEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.SequenceRootEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.ServiceSequenceEditPartFactory;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.helpers.ServiceSequenceSaveAndLoadHelper;
import org.eclipse.fordiac.ide.gef.DiagramEditorWithFlyoutPalette;
import org.eclipse.fordiac.ide.gef.FordiacContextMenuProvider;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.gef.figures.AbstractFreeformFigure;
import org.eclipse.fordiac.ide.gef.figures.ModuloFreeformFigure;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.Service;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class ServiceSequenceEditor
extends DiagramEditorWithFlyoutPalette
implements IFBTEditorPart {
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setPartName(Messages.ServiceSequenceEditor_Service);
        this.setTitleImage(FordiacImage.ICON_SERVICE_SEQUENCE.getImage());
        this.createPartListener();
    }

    protected void createPartListener() {
        ServiceSequenceEditor.getPartService().addPartListener(new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                FBTypeEditor fbTypeEditor;
                if (part instanceof FBTypeEditor && (fbTypeEditor = (FBTypeEditor)part).getActiveEditor() instanceof ServiceSequenceEditor) {
                    ServiceSequenceEditor.getPartService().removePartListener((IPartListener)this);
                    ServiceSequenceEditor.this.setServiceSequences();
                }
            }

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }
        });
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        if (part.getSite().getPage().getActiveEditor() instanceof FBTypeEditor) {
            this.updateActions(this.getSelectionActions());
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                IStructuredSelection sel = (IStructuredSelection)selection;
                if (sel.getFirstElement() instanceof SequenceRootEditPart) {
                    ((FBType)((SequenceRootEditPart)((Object)sel.getFirstElement())).getModel()).getService();
                } else {
                    Object object = sel.getFirstElement();
                    if (object instanceof OutputPrimitiveEditPart) {
                        OutputPrimitiveEditPart opEP = (OutputPrimitiveEditPart)((Object)object);
                        opEP.getModel();
                    } else {
                        Object object2 = sel.getFirstElement();
                        if (object2 instanceof InputPrimitiveEditPart) {
                            InputPrimitiveEditPart ipEP = (InputPrimitiveEditPart)((Object)object2);
                            ipEP.getModel();
                        }
                    }
                }
            }
        }
    }

    protected PaletteRoot getPaletteRoot() {
        return ServiceInterfacePaletteFactory.createPalette();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public boolean outlineSelectionChanged(Object selectedElement) {
        if (selectedElement != null) {
            EditPart ep;
            EditPart editpart = this.getGraphicalViewer().getEditPartForModel(selectedElement);
            this.getGraphicalViewer().flush();
            if (editpart instanceof EditPart && (ep = editpart).isSelectable()) {
                this.getGraphicalViewer().select(ep);
                return true;
            }
            if (selectedElement instanceof Service) {
                return true;
            }
        }
        return false;
    }

    public void gotoMarker(IMarker marker) {
    }

    public boolean isMarkerTarget(IMarker marker) {
        return false;
    }

    public void reloadType() {
        this.getGraphicalViewer().setContents((Object)this.getType());
    }

    public Object getModel() {
        return this.getType();
    }

    protected EditPartFactory getEditPartFactory() {
        return new ServiceSequenceEditPartFactory((GraphicalEditor)this);
    }

    protected ContextMenuProvider getContextMenuProvider(ScrollingGraphicalViewer viewer, ZoomManager zoomManager) {
        return new FordiacContextMenuProvider((EditPartViewer)viewer, zoomManager, this.getActionRegistry()){

            public void buildContextMenu(IMenuManager menu) {
                super.buildContextMenu(menu);
                IAction action = this.getRegistry().getAction((Object)ActionFactory.DELETE.getId());
                menu.appendToGroup("org.eclipse.gef.group.copy", action);
            }
        };
    }

    protected ScalableFreeformRootEditPart createRootEditPart() {
        return new ZoomScalableFreeformRootEditPart(this.getSite(), this.getActionRegistry()){

            protected AbstractFreeformFigure createDrawingAreaContainer() {
                return new ModuloFreeformFigure((ZoomScalableFreeformRootEditPart)this, false);
            }
        };
    }

    protected Point getInitialScrollPos(GraphicalEditPart rootEditPart) {
        FreeformViewport rootviewPort = (FreeformViewport)rootEditPart.getFigure();
        return new Point(ServiceSequenceEditor.calculateTopLeftScrollPosition(rootviewPort.getHorizontalRangeModel()), ServiceSequenceEditor.calculateTopLeftScrollPosition(rootviewPort.getVerticalRangeModel()));
    }

    private static int calculateTopLeftScrollPosition(RangeModel rangeModel) {
        return rangeModel.getExtent();
    }

    protected TransferDropTargetListener createTransferDropTargetListener() {
        return null;
    }

    public void doSaveAs() {
    }

    public Object getSelectableObject() {
        if (this.getGraphicalViewer() == null) {
            return null;
        }
        return this.getGraphicalViewer().getRootEditPart();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IContentOutlinePage.class) {
            return null;
        }
        if (adapter == Service.class) {
            return adapter.cast(this.getType().getService());
        }
        return (T)super.getAdapter(adapter);
    }

    private static IPartService getPartService() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService();
    }

    void setServiceSequences() {
        List<ServiceSequence> serviceSeqs = ServiceSequenceSaveAndLoadHelper.loadServiceSequencesFromFile(this.getType());
        CompoundCommand cmds = new CompoundCommand();
        for (ServiceSequence seq : serviceSeqs) {
            cmds.add((Command)new CreateServiceSequenceCommand(this.getType().getService(), seq));
        }
        if (cmds.canExecute()) {
            cmds.execute();
        }
    }

    public void setInput(IEditorInput input) {
        this.checkEditorInput(input);
        super.setInput(input);
    }
}

