/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.handlers;

import org.eclipse.fordiac.ide.model.ui.editors.AdvancedScrollingGraphicalViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;

public class AdvancedGraphicalViewerKeyHandler
extends GraphicalViewerKeyHandler {
    private static final int SCROLL_SPEED_X = 600;
    private static final int SCROLL_SPEED_Y = 300;
    private int currentStateMask;

    public AdvancedGraphicalViewerKeyHandler(AdvancedScrollingGraphicalViewer viewer) {
        super((GraphicalViewer)viewer);
    }

    public boolean keyPressed(KeyEvent event) {
        boolean modifierPressed = (event.stateMask & SWT.MODIFIER_MASK) != 0;
        this.currentStateMask = (event.keyCode & SWT.MODIFIER_MASK) + (event.stateMask & SWT.MODIFIER_MASK);
        switch (event.keyCode) {
            case 0x1000002: {
                if (modifierPressed) break;
                this.getViewer().scrollByOffset(0, 300);
                return true;
            }
            case 0x1000001: {
                if (modifierPressed) break;
                this.getViewer().scrollByOffset(0, -300);
                return true;
            }
            case 0x1000004: {
                if (modifierPressed) break;
                this.getViewer().scrollByOffset(600, 0);
                return true;
            }
            case 0x1000003: {
                if (modifierPressed) break;
                this.getViewer().scrollByOffset(-600, 0);
                return true;
            }
            case 0x1000006: {
                if ((event.stateMask & 0x20000) != 0) {
                    this.getViewer().scrollByOffset(this.getViewer().getFigureCanvasSize().x, 0);
                } else {
                    this.getViewer().scrollByOffset(0, this.getViewer().getFigureCanvasSize().y);
                }
                return true;
            }
            case 0x1000005: {
                if ((event.stateMask & 0x20000) != 0) {
                    this.getViewer().scrollByOffset(-this.getViewer().getFigureCanvasSize().x, 0);
                } else {
                    this.getViewer().scrollByOffset(0, -this.getViewer().getFigureCanvasSize().y);
                }
                return true;
            }
            default: {
                return super.keyPressed(event);
            }
        }
        return false;
    }

    public boolean keyReleased(KeyEvent event) {
        this.currentStateMask = event.stateMask - (event.keyCode & SWT.MODIFIER_MASK);
        return super.keyReleased(event);
    }

    public AdvancedScrollingGraphicalViewer getViewer() {
        return (AdvancedScrollingGraphicalViewer)super.getViewer();
    }

    public int getCurrentStateMask() {
        return this.currentStateMask;
    }
}

