/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.time.LocalTime;
import java.time.temporal.ChronoField;
import org.eclipse.fordiac.ide.model.data.LtodType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyDateValue;
import org.eclipse.fordiac.ide.model.value.TypedValueConverter;

public final class LTimeOfDayValue
implements AnyDateValue {
    public static final LTimeOfDayValue DEFAULT = new LTimeOfDayValue(0L);
    private final long value;

    private LTimeOfDayValue(long value) {
        ChronoField.NANO_OF_DAY.checkValidValue(value);
        this.value = value;
    }

    public static LTimeOfDayValue toLTimeOfDayValue(long value) {
        return new LTimeOfDayValue(value);
    }

    public static LTimeOfDayValue toLTimeOfDayValue(Number value) {
        return new LTimeOfDayValue(value.longValue());
    }

    public static LTimeOfDayValue toLTimeOfDayValue(LocalTime value) {
        return LTimeOfDayValue.toLTimeOfDayValue(value.toNanoOfDay());
    }

    public static LTimeOfDayValue toLTimeOfDayValue(String value) {
        return LTimeOfDayValue.toLTimeOfDayValue((LocalTime)TypedValueConverter.INSTANCE_LTIME_OF_DAY.toValue(value));
    }

    public static LTimeOfDayValue toLTimeOfDayValue(AnyDateValue value) {
        return LTimeOfDayValue.toLTimeOfDayValue(value.toNanos());
    }

    public LtodType getType() {
        return IecTypes.ElementaryTypes.LTIME_OF_DAY;
    }

    @Override
    public long toNanos() {
        return this.value;
    }

    public LocalTime toLocalTime() {
        return LocalTime.ofNanoOfDay(this.value);
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LTimeOfDayValue other = (LTimeOfDayValue)obj;
        return this.value == other.value;
    }

    public String toString() {
        return TypedValueConverter.INSTANCE_LTIME_OF_DAY.toString((Object)this.toLocalTime());
    }
}

