/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomainEvent;
import org.eclipse.emf.transaction.TransactionalEditingDomainListener;
import org.eclipse.emf.transaction.TransactionalEditingDomainListenerImpl;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.tools.api.SiriusPlugin;

final class Saver
extends TransactionalEditingDomainListenerImpl {
    boolean deferSaveToPostCommit;
    boolean saveInExclusiveTransaction;
    AtomicBoolean domainDisposed = new AtomicBoolean(false);
    private TransactionalEditingDomain domain;
    private final DAnalysisSessionImpl session;
    private AtomicBoolean saveOnPostCommit = new AtomicBoolean(false);
    private Map<?, ?> savedOptions;
    private IProgressMonitor savedMonitor;
    private AtomicBoolean isSaving = new AtomicBoolean();

    Saver(DAnalysisSessionImpl session) {
        this.session = session;
        this.domain = session.getTransactionalEditingDomain();
        TransactionalEditingDomain.Lifecycle lifecycle = (TransactionalEditingDomain.Lifecycle)TransactionUtil.getAdapter((TransactionalEditingDomain)this.domain, TransactionalEditingDomain.Lifecycle.class);
        if (lifecycle != null) {
            lifecycle.addTransactionalEditingDomainListener((TransactionalEditingDomainListener)this);
        }
    }

    public void transactionClosed(TransactionalEditingDomainEvent event) {
        if (!event.getTransaction().isReadOnly() && this.saveOnPostCommit.get()) {
            this.saveNow(this.savedOptions, this.savedMonitor, this.saveInExclusiveTransaction);
        }
    }

    public void save(Map<?, ?> options, IProgressMonitor monitor) {
        boolean tip = this.transactionInProgress();
        if (tip && this.deferSaveToPostCommit) {
            this.saveAfterTransactionClosing(options, monitor);
        } else {
            this.saveNow(options, monitor, this.saveInExclusiveTransaction && !tip && !this.domainDisposed.get());
        }
    }

    private void saveAfterTransactionClosing(Map<?, ?> options, IProgressMonitor monitor) {
        this.savedOptions = options;
        this.savedMonitor = monitor;
        this.saveOnPostCommit.set(true);
    }

    private void saveNow(final Map<?, ?> options, IProgressMonitor monitor, final boolean runExclusive) {
        if (this.alreadyIsInWorkspaceModificationOperation()) {
            this.wrappedSave(options, monitor, runExclusive);
        } else {
            IWorkspaceRoot workspaceRoot = EcorePlugin.getWorkspaceRoot();
            if (workspaceRoot != null) {
                try {
                    workspaceRoot.getWorkspace().run(new IWorkspaceRunnable(){

                        public void run(IProgressMonitor progressMonitor) throws CoreException {
                            Saver.this.wrappedSave(options, progressMonitor, runExclusive);
                        }
                    }, (IProgressMonitor)new SubProgressMonitor(monitor, -1));
                }
                catch (CoreException e) {
                    SiriusPlugin.getDefault().error(Messages.Saver_savingErrorMsg, e);
                }
            } else {
                this.wrappedSave(options, monitor, runExclusive);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wrappedSave(Map<?, ?> options, IProgressMonitor monitor, boolean runExclusive) {
        AtomicBoolean atomicBoolean = this.isSaving;
        synchronized (atomicBoolean) {
            if (!this.isSaving.get()) {
                try {
                    this.isSaving.set(true);
                    this.session.doSave(options, monitor, runExclusive);
                }
                finally {
                    this.disarm();
                    this.isSaving.set(false);
                }
            }
        }
    }

    private boolean alreadyIsInWorkspaceModificationOperation() {
        Job currentJob = Job.getJobManager().currentJob();
        return currentJob != null && currentJob.getRule() != null;
    }

    protected void disarm() {
        this.savedOptions = null;
        this.savedMonitor = null;
        this.saveOnPostCommit.set(false);
    }

    private boolean transactionInProgress() {
        if (this.session.getTransactionalEditingDomain() instanceof InternalTransactionalEditingDomain) {
            InternalTransaction tx = ((InternalTransactionalEditingDomain)this.session.getTransactionalEditingDomain()).getActiveTransaction();
            return tx != null;
        }
        return false;
    }

    public void dispose() {
        TransactionalEditingDomain.Lifecycle lifecycle = (TransactionalEditingDomain.Lifecycle)TransactionUtil.getAdapter((TransactionalEditingDomain)this.domain, TransactionalEditingDomain.Lifecycle.class);
        if (lifecycle != null) {
            lifecycle.removeTransactionalEditingDomainListener((TransactionalEditingDomainListener)this);
        }
        this.disarm();
        this.domain = null;
    }
}

