/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form.upload.resource;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.resource.IUploadsFileManager;
import org.apache.wicket.util.file.File;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.lang.Args;

public class FolderUploadsFileManager
implements IUploadsFileManager {
    private final File folder;

    public FolderUploadsFileManager(File folder) {
        Args.notNull(folder, "folder");
        if (!folder.exists()) {
            try {
                Files.createDirectories(folder.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new WicketRuntimeException(e);
            }
        } else if (folder.exists() && !folder.isDirectory()) {
            throw new IllegalArgumentException("Not a folder : " + folder.getAbsolutePath());
        }
        this.folder = folder;
    }

    public File getFolder() {
        return this.folder;
    }

    @Override
    public void save(FileUpload fileItem, String uploadFieldId) {
        File uploadFieldFolder = new File(this.getFolder(), uploadFieldId);
        uploadFieldFolder.mkdirs();
        try {
            IOUtils.copy(fileItem.getInputStream(), (OutputStream)new FileOutputStream(new File(uploadFieldFolder, fileItem.getClientFileName())));
        }
        catch (IOException e) {
            throw new WicketRuntimeException(e);
        }
    }

    @Override
    public File getFile(String uploadFieldId, String clientFileName) {
        return new File(new File(this.getFolder(), uploadFieldId), clientFileName);
    }
}

