/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.Component;
import org.apache.wicket.IRequestListener;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnEventHeaderItem;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IFormSubmitter;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;

public class FormComponentUpdatingBehavior
extends Behavior
implements IRequestListener {
    private FormComponent<?> formComponent;

    @Override
    public boolean getStatelessHint(Component component) {
        return false;
    }

    @Override
    public final void bind(Component component) {
        Args.notNull(component, "component");
        if (!(component instanceof FormComponent)) {
            throw new WicketRuntimeException("Behavior " + this.getClass().getName() + " can only be added to an instance of a FormComponent");
        }
        if (this.formComponent != null) {
            throw new IllegalStateException("this kind of handler cannot be attached to multiple components; it is already attached to component " + String.valueOf(this.formComponent) + ", but component " + String.valueOf(component) + " wants to be attached too");
        }
        this.formComponent = (FormComponent)component;
        this.formComponent.setRenderBodyOnly(false);
        this.onBind();
    }

    protected void onBind() {
    }

    public final FormComponent<?> getFormComponent() {
        return this.formComponent;
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        CharSequence url = component.urlForListener(this, new PageParameters());
        String event = this.getEvent();
        String condition = String.format("if (event.target.name !== '%s') return; ", this.formComponent.getInputName());
        Form form = component.findParent(Form.class);
        if (form != null) {
            response.render(OnEventHeaderItem.forComponent(component, event, condition + String.valueOf(form.getJsForListenerUrl(url.toString()))));
        } else {
            char separator = url.toString().indexOf(63) > -1 ? (char)'&' : '?';
            response.render(OnEventHeaderItem.forComponent(component, event, condition + String.format("window.location.href='%s%s%s=' + %s;", url, Character.valueOf(separator), this.formComponent.getInputName(), this.getJSValue())));
        }
    }

    protected String getEvent() {
        return "change";
    }

    private String getJSValue() {
        if (this.formComponent instanceof DropDownChoice) {
            return "this.options[this.selectedIndex].value";
        }
        if (this.formComponent instanceof CheckBox) {
            return "this.checked";
        }
        return "event.target.value";
    }

    private void process() {
        try {
            this.formComponent.validate();
            if (this.formComponent.isValid()) {
                if (this.getUpdateModel()) {
                    this.formComponent.valid();
                    this.formComponent.updateModel();
                }
                this.onUpdate();
            } else {
                this.formComponent.invalid();
                this.onError(null);
            }
        }
        catch (RuntimeException e) {
            this.onError(e);
        }
    }

    protected boolean getUpdateModel() {
        return true;
    }

    protected void onUpdate() {
    }

    protected void onError(RuntimeException e) {
        if (e != null) {
            throw e;
        }
    }

    @Override
    public final void onRequest() {
        Form form = this.formComponent.findParent(Form.class);
        if (form == null) {
            this.formComponent.inputChanged();
            this.process();
        } else {
            form.getRootForm().onFormSubmitted(new IFormSubmitter(){

                @Override
                public void onSubmit() {
                    FormComponentUpdatingBehavior.this.process();
                }

                @Override
                public void onError() {
                }

                @Override
                public void onAfterSubmit() {
                }

                @Override
                public Form<?> getForm() {
                    return FormComponentUpdatingBehavior.this.formComponent.getForm();
                }

                @Override
                public boolean getDefaultFormProcessing() {
                    return false;
                }
            });
        }
    }
}

