/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.util;

import java.io.Serializable;
import java.util.Comparator;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.structure.Element;

public final class ElementFunctionComparator<V>
implements Comparator<Element>,
Serializable {
    private final Function<Element, V> elementFunction;
    private final Comparator<V> valueComparator;

    public ElementFunctionComparator(Function<Element, V> elementFunction, Comparator<V> valueComparator) {
        this.elementFunction = elementFunction;
        this.valueComparator = valueComparator;
    }

    public Function<Element, V> getElementFunction() {
        return this.elementFunction;
    }

    public Comparator<V> getValueComparator() {
        return this.valueComparator;
    }

    @Override
    public int compare(Element elementA, Element elementB) {
        return this.valueComparator.compare(this.elementFunction.apply(elementA), this.elementFunction.apply(elementB));
    }

    public String toString() {
        return this.valueComparator.toString() + "(" + this.elementFunction + ")";
    }
}

