/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.StringLocalStep;

public final class ReplaceLocalStep<S, E>
extends StringLocalStep<S, E> {
    private final String oldChar;
    private final String newChar;

    public ReplaceLocalStep(Traversal.Admin traversal, String oldChar, String newChar) {
        super(traversal);
        this.oldChar = oldChar;
        this.newChar = newChar;
    }

    @Override
    protected E applyStringOperation(String item) {
        return (E)StringUtils.replace((String)item, (String)this.oldChar, (String)this.newChar);
    }

    @Override
    public String getStepName() {
        return "replace(local)";
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (null != this.oldChar ? this.oldChar.hashCode() : 0);
        result = 31 * result + (null != this.newChar ? this.newChar.hashCode() : 0);
        return result;
    }
}

