/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.http.common.api;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;

public class HttpHeaders
implements Map<String, List<String>> {
    protected final Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
    protected final String rawStringHeaders;

    public HttpHeaders() {
        this(null);
    }

    protected HttpHeaders(String rawStringHeaders) {
        this.rawStringHeaders = rawStringHeaders;
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.headers.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.headers.containsValue(value);
    }

    @Override
    public List<String> get(Object key) {
        return this.headers.get(key);
    }

    @Override
    public List<String> put(String key, List<String> value) {
        return this.headers.put(key, value);
    }

    @Override
    public List<String> remove(Object key) {
        return this.headers.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> m) {
        this.headers.putAll(m);
    }

    @Override
    public void clear() {
        this.headers.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.headers.keySet();
    }

    @Override
    public Collection<List<String>> values() {
        return this.headers.values();
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.headers.entrySet();
    }

    public void add(String headerName, String headerValue) {
        this.headers.computeIfAbsent(headerName, key -> new ArrayList()).add(headerValue);
    }

    public String formatAsString() {
        if (this.rawStringHeaders != null) {
            return this.rawStringHeaders;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            String headerName = entry.getKey();
            for (String headerValue : entry.getValue()) {
                sb.append(headerName);
                if (headerValue != null) {
                    sb.append(": ").append(headerValue);
                } else {
                    sb.append(":");
                }
                sb.append('\n');
            }
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static HttpHeaders parseFromString(String headersString) {
        HttpHeaders headers = new HttpHeaders(headersString);
        if (StringUtils.isNotEmpty((CharSequence)headersString)) {
            try (BufferedReader reader = new BufferedReader(new StringReader(headersString));){
                String line = reader.readLine();
                while (line != null) {
                    int colonIndex = line.indexOf(58);
                    if (colonIndex > 0) {
                        String headerName = line.substring(0, colonIndex);
                        if (line.length() > colonIndex + 2) {
                            headers.add(headerName, StringUtils.strip((String)line.substring(colonIndex + 1)));
                        } else {
                            headers.add(headerName, "");
                        }
                        line = reader.readLine();
                        continue;
                    }
                    throw new FlowableIllegalArgumentException("Header line '" + line + "' is invalid");
                }
            }
            catch (IOException ex) {
                throw new FlowableException("IO exception occurred", (Throwable)ex);
            }
        }
        return headers;
    }
}

