/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.tx;

public final class TimerSpec {
    private static final int UNITIALIZED_TIME_INTERVAL = -1;
    private final Signature signature;
    private long millis;
    private final int nanos;
    private long mark = -1L;
    public static final Signature NO_ARGS = new Signature("wait()", 0);
    public static final Signature LONG = new Signature("wait(long)", 1);
    public static final Signature LONG_INT = new Signature("wait(long, int)", 2);

    public TimerSpec() {
        this(NO_ARGS, -1L, -1);
    }

    public TimerSpec(long millis) {
        this(LONG, millis, -1);
    }

    public TimerSpec(long millis, int nanos) {
        this(LONG_INT, millis, nanos);
    }

    private TimerSpec(Signature signature, long millis, int nanos) {
        this.signature = signature;
        if (signature == LONG) {
            if (millis < 0L) {
                throw new IllegalArgumentException("Invalid milliseconds argument to wait(long): " + millis);
            }
        } else if (signature == LONG_INT) {
            if (millis < 0L) {
                throw new IllegalArgumentException("Invalid milliseconds argument to wait(long, int): " + millis);
            }
            if (nanos < 0) {
                throw new IllegalArgumentException("Invalid nanoseconds argument to wait(long, int): " + nanos);
            }
        }
        this.millis = millis;
        this.nanos = nanos;
    }

    public boolean hasTimeout() {
        return this.getSignature() != NO_ARGS;
    }

    public boolean needsToWait() {
        return this.millis > 0L || this.nanos > 0;
    }

    public long getMillis() {
        return this.millis;
    }

    public int getNanos() {
        return this.nanos;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public void mark() {
        this.mark = System.currentTimeMillis();
    }

    public void adjust() {
        if (this.mark <= -1L || this.signature == NO_ARGS) {
            return;
        }
        long now = System.currentTimeMillis();
        this.millis -= now - this.mark;
        if (this.millis <= 0L) {
            this.millis = 1L;
        }
    }

    public String toString() {
        if (this.signature == NO_ARGS) {
            return this.signature.toString();
        }
        StringBuffer rv = new StringBuffer("wait(");
        if (this.signature == LONG) {
            rv.append(this.getMillis());
        } else if (this.signature == LONG_INT) {
            rv.append(this.getMillis()).append(", ").append(this.getNanos());
        }
        rv.append(")");
        return rv.toString();
    }

    public static final class Signature {
        private final String desc;
        private final int argCount;

        private Signature(String desc, int numArgs) {
            this.desc = desc;
            this.argCount = numArgs;
        }

        public int getArgCount() {
            return this.argCount;
        }

        public String toString() {
            return this.desc;
        }
    }
}

