/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.queue;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Generated;
import org.apereo.cas.ticket.queue.BaseMessageQueueCommand;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.PublisherIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class DeleteTicketMessageQueueCommand
extends BaseMessageQueueCommand {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteTicketMessageQueueCommand.class);
    private static final long serialVersionUID = 8183330712274484245L;
    @JsonProperty
    private String ticketId;

    @JsonCreator
    public DeleteTicketMessageQueueCommand(@JsonProperty(value="id") PublisherIdentifier id, @JsonProperty(value="ticketId") String ticketId) {
        super(id);
        this.ticketId = ticketId;
    }

    @Override
    public void execute(TicketRegistry registry) throws Exception {
        LOGGER.debug("Executing queue command on ticket registry id [{}] to delete ticket [{}]", (Object)this.getId().getId(), (Object)this.ticketId);
        registry.deleteTicket(this.ticketId);
    }

    @Generated
    public String getTicketId() {
        return this.ticketId;
    }
}

