/*
 * Decompiled with CFR 0.152.
 */
package liquibase.lockservice;

import java.security.SecureRandom;
import java.text.DateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.core.DB2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorFactory;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.lockservice.DatabaseChangeLogLock;
import liquibase.lockservice.LockService;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CreateDatabaseChangeLogLockTableStatement;
import liquibase.statement.core.DropTableStatement;
import liquibase.statement.core.InitializeDatabaseChangeLogLockTableStatement;
import liquibase.statement.core.LockDatabaseChangeLogStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.statement.core.SelectFromDatabaseChangeLogLockStatement;
import liquibase.statement.core.UnlockDatabaseChangeLogStatement;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Table;

public class StandardLockService
implements LockService {
    private static ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    protected Database database;
    protected boolean hasChangeLogLock;
    private Long changeLogLockPollRate;
    private Long changeLogLockRecheckTime;
    private Boolean hasDatabaseChangeLogLockTable;
    private boolean isDatabaseChangeLogLockTableInitialized;
    private ObjectQuotingStrategy quotingStrategy;
    private final SecureRandom random = new SecureRandom();

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public boolean supports(Database database) {
        return true;
    }

    @Override
    public void setDatabase(Database database) {
        this.database = database;
    }

    public Long getChangeLogLockWaitTime() {
        if (this.changeLogLockPollRate != null) {
            return this.changeLogLockPollRate;
        }
        return GlobalConfiguration.CHANGELOGLOCK_WAIT_TIME.getCurrentValue();
    }

    @Override
    public void setChangeLogLockWaitTime(long changeLogLockWaitTime) {
        this.changeLogLockPollRate = changeLogLockWaitTime;
    }

    public Long getChangeLogLockRecheckTime() {
        if (this.changeLogLockRecheckTime != null) {
            return this.changeLogLockRecheckTime;
        }
        return GlobalConfiguration.CHANGELOGLOCK_POLL_RATE.getCurrentValue();
    }

    @Override
    public void setChangeLogLockRecheckTime(long changeLogLockRecheckTime) {
        this.changeLogLockRecheckTime = changeLogLockRecheckTime;
    }

    @Override
    public void init() throws DatabaseException {
        boolean createdTable = false;
        Executor executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database);
        int maxIterations = 10;
        if (executor instanceof LoggingExecutor) {
            maxIterations = this.hasDatabaseChangeLogLockTable() ? 0 : 1;
        }
        for (int i2 = 0; i2 < maxIterations; ++i2) {
            try {
                if (!this.hasDatabaseChangeLogLockTable(true)) {
                    executor.comment("Create Database Lock Table");
                    executor.execute(new CreateDatabaseChangeLogLockTableStatement());
                    this.database.commit();
                    Scope.getCurrentScope().getLog(this.getClass()).fine("Created database lock table with name: " + this.database.escapeTableName(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName(), this.database.getDatabaseChangeLogLockTableName()));
                    this.hasDatabaseChangeLogLockTable = true;
                    createdTable = true;
                    this.hasDatabaseChangeLogLockTable = true;
                }
                if (!this.isDatabaseChangeLogLockTableInitialized(createdTable, true)) {
                    executor.comment("Initialize Database Lock Table");
                    executor.execute(new InitializeDatabaseChangeLogLockTableStatement());
                    this.database.commit();
                }
                if ((!executor.updatesDatabase() || !(this.database instanceof DerbyDatabase) || !((DerbyDatabase)this.database).supportsBooleanDataType()) && (!this.database.getClass().isAssignableFrom(DB2Database.class) || !((DB2Database)this.database).supportsBooleanDataType())) continue;
                String lockTable = this.database.escapeTableName(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName(), this.database.getDatabaseChangeLogLockTableName());
                Object obj = executor.queryForObject(new RawSqlStatement("SELECT MIN(locked) AS test FROM " + lockTable + " FETCH FIRST ROW ONLY"), Object.class);
                if (obj instanceof Boolean) continue;
                executor.execute(new DropTableStatement(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName(), this.database.getDatabaseChangeLogLockTableName(), false));
                executor.execute(new CreateDatabaseChangeLogLockTableStatement());
                executor.execute(new InitializeDatabaseChangeLogLockTableStatement());
                continue;
            }
            catch (Exception e2) {
                if (i2 == maxIterations - 1) {
                    throw e2;
                }
                Scope.getCurrentScope().getLog(this.getClass()).fine("Failed to create or initialize the lock table, trying again, iteration " + (i2 + 1) + " of " + maxIterations, e2);
                this.database.rollback();
                try {
                    Thread.sleep(this.random.nextInt(1000));
                    continue;
                }
                catch (InterruptedException ex2) {
                    Scope.getCurrentScope().getLog(this.getClass()).warning("Lock table retry loop thread sleep interrupted", ex2);
                }
            }
        }
    }

    public boolean isDatabaseChangeLogLockTableInitialized(boolean tableJustCreated) {
        return this.isDatabaseChangeLogLockTableInitialized(tableJustCreated, false);
    }

    private boolean isDatabaseChangeLogLockTableInitialized(boolean tableJustCreated, boolean forceRecheck) {
        if (!this.isDatabaseChangeLogLockTableInitialized || forceRecheck) {
            Executor executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database);
            try {
                this.isDatabaseChangeLogLockTableInitialized = executor.queryForInt(new RawSqlStatement("SELECT COUNT(*) FROM " + this.database.escapeTableName(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName(), this.database.getDatabaseChangeLogLockTableName()))) > 0;
            }
            catch (LiquibaseException e2) {
                if (executor.updatesDatabase()) {
                    throw new UnexpectedLiquibaseException(e2);
                }
                this.isDatabaseChangeLogLockTableInitialized = !tableJustCreated;
            }
        }
        return this.isDatabaseChangeLogLockTableInitialized;
    }

    @Override
    public boolean hasChangeLogLock() {
        return this.hasChangeLogLock;
    }

    private boolean hasDatabaseChangeLogLockTable(boolean forceRecheck) {
        if (forceRecheck || this.hasDatabaseChangeLogLockTable == null) {
            try {
                this.hasDatabaseChangeLogLockTable = SnapshotGeneratorFactory.getInstance().hasDatabaseChangeLogLockTable(this.database);
            }
            catch (LiquibaseException e2) {
                throw new UnexpectedLiquibaseException(e2);
            }
        }
        return this.hasDatabaseChangeLogLockTable;
    }

    public boolean hasDatabaseChangeLogLockTable() throws DatabaseException {
        return this.hasDatabaseChangeLogLockTable(false);
    }

    @Override
    public void waitForLock() throws LockException {
        boolean locked = false;
        long timeToGiveUp = new Date().getTime() + this.getChangeLogLockWaitTime() * 1000L * 60L;
        while (!locked && new Date().getTime() < timeToGiveUp) {
            locked = this.acquireLock();
            if (locked) continue;
            Scope.getCurrentScope().getLog(this.getClass()).info("Waiting for changelog lock....");
            try {
                Thread.sleep(this.getChangeLogLockRecheckTime() * 1000L);
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
        }
        if (!locked) {
            String lockedBy;
            DatabaseChangeLogLock[] locks = this.listLocks();
            if (locks.length > 0) {
                DatabaseChangeLogLock lock = locks[0];
                lockedBy = lock.getLockedBy() + " since " + DateFormat.getDateTimeInstance(3, 3).format(lock.getLockGranted());
            } else {
                lockedBy = "UNKNOWN";
            }
            throw new LockException("Could not acquire change log lock.  Currently locked by " + lockedBy);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean acquireLock() throws LockException {
        if (this.hasChangeLogLock) {
            return true;
        }
        this.quotingStrategy = this.database.getObjectQuotingStrategy();
        Executor executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database);
        try {
            this.database.rollback();
            this.init();
            Boolean locked = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database).queryForObject(new SelectFromDatabaseChangeLogLockStatement("LOCKED"), Boolean.class);
            if (locked.booleanValue()) {
                boolean bl2 = false;
                return bl2;
            }
            executor.comment("Lock Database");
            int rowsUpdated = executor.update(new LockDatabaseChangeLogStatement());
            if (rowsUpdated == -1 && this.database instanceof MSSQLDatabase) {
                Scope.getCurrentScope().getLog(this.getClass()).fine("Database did not return a proper row count (Might have NOCOUNT enabled)");
                this.database.rollback();
                Sql[] sql = SqlGeneratorFactory.getInstance().generateSql(new LockDatabaseChangeLogStatement(), this.database);
                if (sql.length != 1) {
                    throw new UnexpectedLiquibaseException("Did not expect " + sql.length + " statements");
                }
                rowsUpdated = executor.update(new RawSqlStatement("EXEC sp_executesql N'SET NOCOUNT OFF " + sql[0].toSql().replace("'", "''") + "'"));
            }
            if (rowsUpdated > 1) {
                throw new LockException("Did not update change log lock correctly");
            }
            if (rowsUpdated == 0) {
                boolean bl3 = false;
                return bl3;
            }
            this.database.commit();
            Scope.getCurrentScope().getLog(this.getClass()).info(coreBundle.getString("successfully.acquired.change.log.lock"));
            this.hasChangeLogLock = true;
            this.database.setCanCacheLiquibaseTableInfo(true);
            boolean bl4 = true;
            return bl4;
        }
        catch (Exception e2) {
            throw new LockException(e2);
        }
        finally {
            try {
                this.database.rollback();
            }
            catch (DatabaseException databaseException) {}
        }
    }

    @Override
    public void releaseLock() throws LockException {
        ObjectQuotingStrategy incomingQuotingStrategy = null;
        if (this.quotingStrategy != null) {
            incomingQuotingStrategy = this.database.getObjectQuotingStrategy();
            this.database.setObjectQuotingStrategy(this.quotingStrategy);
        }
        Executor executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database);
        try {
            if (this.hasDatabaseChangeLogLockTable()) {
                executor.comment("Release Database Lock");
                this.database.rollback();
                int updatedRows = executor.update(new UnlockDatabaseChangeLogStatement());
                if (updatedRows == -1 && this.database instanceof MSSQLDatabase) {
                    Scope.getCurrentScope().getLog(this.getClass()).fine("Database did not return a proper row count (Might have NOCOUNT enabled.)");
                    this.database.rollback();
                    Sql[] sql = SqlGeneratorFactory.getInstance().generateSql(new UnlockDatabaseChangeLogStatement(), this.database);
                    if (sql.length != 1) {
                        throw new UnexpectedLiquibaseException("Did not expect " + sql.length + " statements");
                    }
                    updatedRows = executor.update(new RawSqlStatement("EXEC sp_executesql N'SET NOCOUNT OFF " + sql[0].toSql().replace("'", "''") + "'"));
                }
                if (updatedRows != 1) {
                    throw new LockException("Did not update change log lock correctly.\n\n" + updatedRows + " rows were updated instead of the expected 1 row using executor " + executor.getClass().getName() + " there are " + executor.queryForInt(new RawSqlStatement("SELECT COUNT(*) FROM " + this.database.getDatabaseChangeLogLockTableName())) + " rows in the table");
                }
                this.database.commit();
            }
        }
        catch (Exception e2) {
            throw new LockException(e2);
        }
        finally {
            try {
                this.hasChangeLogLock = false;
                this.database.setCanCacheLiquibaseTableInfo(false);
                Scope.getCurrentScope().getLog(this.getClass()).info("Successfully released change log lock");
                this.database.rollback();
            }
            catch (DatabaseException databaseException) {}
            if (incomingQuotingStrategy != null) {
                this.database.setObjectQuotingStrategy(incomingQuotingStrategy);
            }
        }
    }

    @Override
    public DatabaseChangeLogLock[] listLocks() throws LockException {
        try {
            if (!this.hasDatabaseChangeLogLockTable()) {
                return new DatabaseChangeLogLock[0];
            }
            ArrayList<DatabaseChangeLogLock> allLocks = new ArrayList<DatabaseChangeLogLock>();
            SelectFromDatabaseChangeLogLockStatement sqlStatement = new SelectFromDatabaseChangeLogLockStatement("ID", "LOCKED", "LOCKGRANTED", "LOCKEDBY");
            List<Map<String, ?>> rows = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database).queryForList(sqlStatement);
            for (Map<String, ?> columnMap : rows) {
                Object lockedValue = columnMap.get("LOCKED");
                Boolean locked = lockedValue instanceof Number ? Boolean.valueOf(((Number)lockedValue).intValue() == 1) : (Boolean)lockedValue;
                if (locked == null || !locked.booleanValue()) continue;
                Object lockGranted = columnMap.get("LOCKGRANTED");
                Date castedLockGranted = lockGranted instanceof LocalDateTime ? Date.from(((LocalDateTime)lockGranted).atZone(ZoneId.systemDefault()).toInstant()) : (Date)lockGranted;
                allLocks.add(new DatabaseChangeLogLock(((Number)columnMap.get("ID")).intValue(), castedLockGranted, (String)columnMap.get("LOCKEDBY")));
            }
            return allLocks.toArray(new DatabaseChangeLogLock[allLocks.size()]);
        }
        catch (Exception e2) {
            throw new LockException(e2);
        }
    }

    @Override
    public void forceReleaseLock() throws LockException, DatabaseException {
        this.init();
        this.releaseLock();
    }

    @Override
    public void reset() {
        this.hasChangeLogLock = false;
        this.hasDatabaseChangeLogLockTable = null;
        this.isDatabaseChangeLogLockTableInitialized = false;
    }

    @Override
    public void destroy() throws DatabaseException {
        try {
            Relation example = new Table().setName(this.database.getDatabaseChangeLogLockTableName()).setSchema(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName());
            if (SnapshotGeneratorFactory.getInstance().has(example, this.database)) {
                Relation table = SnapshotGeneratorFactory.getInstance().createSnapshot(example, this.database);
                DiffOutputControl diffOutputControl = new DiffOutputControl(true, true, false, null);
                Change[] change = ChangeGeneratorFactory.getInstance().fixUnexpected(table, diffOutputControl, this.database, this.database);
                SqlStatement[] sqlStatement = change[0].generateStatements(this.database);
                Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database).execute(sqlStatement[0]);
            }
            this.reset();
        }
        catch (InvalidExampleException e2) {
            throw new UnexpectedLiquibaseException(e2);
        }
    }
}

