/*
 * Decompiled with CFR 0.152.
 */
package liquibase.license;

import liquibase.license.LocationType;

public class Location {
    public String name;
    public LocationType type;
    public String value;

    public Location(String name, LocationType type, String value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public Location(String value, LocationType type) {
        this(value, type, value);
    }

    public String toString() {
        switch (this.type) {
            case ENVIRONMENT_VARIABLE: {
                return String.format("Environment variable '%s' (%s)", this.name, this.getPath());
            }
            case FILE_PATH: {
                return String.format("File path '%s' (%s)", this.value, this.name);
            }
            case SYSTEM_PROPERTY: {
                return String.format("System property '%s' (%s)", this.value, this.name);
            }
            case BASE64_STRING: {
                int substring_length = 10;
                if (this.value.length() < 10) {
                    substring_length = this.value.length();
                }
                return String.format("Base64 string starting with '%s' (%s)", this.value.substring(0, substring_length), this.name);
            }
        }
        return String.format("%s %s %s", new Object[]{this.type, this.name, this.value});
    }

    public String toDisplayString() {
        switch (this.type) {
            case ENVIRONMENT_VARIABLE: {
                return String.format("(%s)", this.name);
            }
            case FILE_PATH: {
                return String.format("(%s)", this.name);
            }
            case SYSTEM_PROPERTY: {
                return String.format("(%s)", this.name);
            }
            case BASE64_STRING: {
                return String.format("(%s)", this.name);
            }
        }
        return String.format("%s %s %s", new Object[]{this.type, this.name, this.value});
    }

    public String getPath() {
        String path = null;
        switch (this.type) {
            case ENVIRONMENT_VARIABLE: {
                path = System.getenv(this.value);
                break;
            }
            case FILE_PATH: {
                path = this.value;
                break;
            }
            case SYSTEM_PROPERTY: {
                path = System.getProperty(this.value);
                break;
            }
            case BASE64_STRING: {
                path = this.value;
                break;
            }
            default: {
                throw new RuntimeException("Unknown location type");
            }
        }
        if (path != null && path.startsWith("file:")) {
            path = path.substring(5);
        }
        return path;
    }
}

