/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.common.ECIEncoderSet;
import com.google.zxing.common.ECIInput;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class MinimalECIInput
implements ECIInput {
    private static final int COST_PER_ECI = 3;
    private final int[] bytes;
    private final int fnc1;

    public MinimalECIInput(String stringToEncode, Charset priorityCharset, int fnc1) {
        this.fnc1 = fnc1;
        ECIEncoderSet encoderSet = new ECIEncoderSet(stringToEncode, priorityCharset, fnc1);
        if (encoderSet.length() == 1) {
            this.bytes = new int[stringToEncode.length()];
            for (int i = 0; i < this.bytes.length; ++i) {
                char c = stringToEncode.charAt(i);
                this.bytes[i] = c == fnc1 ? 1000 : (int)c;
            }
        } else {
            this.bytes = MinimalECIInput.encodeMinimally(stringToEncode, encoderSet, fnc1);
        }
    }

    public int getFNC1Character() {
        return this.fnc1;
    }

    @Override
    public int length() {
        return this.bytes.length;
    }

    @Override
    public boolean haveNCharacters(int index, int n) {
        if (index + n - 1 >= this.bytes.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (!this.isECI(index + i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException("" + index);
        }
        if (this.isECI(index)) {
            throw new IllegalArgumentException("value at " + index + " is not a character but an ECI");
        }
        return this.isFNC1(index) ? (char)this.fnc1 : (char)this.bytes[index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0 || start > end || end > this.length()) {
            throw new IndexOutOfBoundsException("" + start);
        }
        StringBuilder result = new StringBuilder();
        for (int i = start; i < end; ++i) {
            if (this.isECI(i)) {
                throw new IllegalArgumentException("value at " + i + " is not a character but an ECI");
            }
            result.append(this.charAt(i));
        }
        return result;
    }

    @Override
    public boolean isECI(int index) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException("" + index);
        }
        return this.bytes[index] > 255 && this.bytes[index] <= 999;
    }

    public boolean isFNC1(int index) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException("" + index);
        }
        return this.bytes[index] == 1000;
    }

    @Override
    public int getECIValue(int index) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException("" + index);
        }
        if (!this.isECI(index)) {
            throw new IllegalArgumentException("value at " + index + " is not an ECI but a character");
        }
        return this.bytes[index] - 256;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.length(); ++i) {
            if (i > 0) {
                result.append(", ");
            }
            if (this.isECI(i)) {
                result.append("ECI(");
                result.append(this.getECIValue(i));
                result.append(')');
                continue;
            }
            if (this.charAt(i) < '\u0080') {
                result.append('\'');
                result.append(this.charAt(i));
                result.append('\'');
                continue;
            }
            result.append((int)this.charAt(i));
        }
        return result.toString();
    }

    static void addEdge(InputEdge[][] edges, int to, InputEdge edge) {
        if (edges[to][edge.encoderIndex] == null || edges[to][edge.encoderIndex].cachedTotalSize > edge.cachedTotalSize) {
            edges[to][((InputEdge)edge).encoderIndex] = edge;
        }
    }

    static void addEdges(String stringToEncode, ECIEncoderSet encoderSet, InputEdge[][] edges, int from, InputEdge previous, int fnc1) {
        char ch = stringToEncode.charAt(from);
        int start = 0;
        int end = encoderSet.length();
        if (encoderSet.getPriorityEncoderIndex() >= 0 && (ch == fnc1 || encoderSet.canEncode(ch, encoderSet.getPriorityEncoderIndex()))) {
            start = encoderSet.getPriorityEncoderIndex();
            end = start + 1;
        }
        for (int i = start; i < end; ++i) {
            if (ch != fnc1 && !encoderSet.canEncode(ch, i)) continue;
            MinimalECIInput.addEdge(edges, from + 1, new InputEdge(ch, encoderSet, i, previous, fnc1));
        }
    }

    static int[] encodeMinimally(String stringToEncode, ECIEncoderSet encoderSet, int fnc1) {
        int i;
        int inputLength = stringToEncode.length();
        InputEdge[][] edges = new InputEdge[inputLength + 1][encoderSet.length()];
        MinimalECIInput.addEdges(stringToEncode, encoderSet, edges, 0, null, fnc1);
        for (int i2 = 1; i2 <= inputLength; ++i2) {
            int j;
            for (j = 0; j < encoderSet.length(); ++j) {
                if (edges[i2][j] == null || i2 >= inputLength) continue;
                MinimalECIInput.addEdges(stringToEncode, encoderSet, edges, i2, edges[i2][j], fnc1);
            }
            for (j = 0; j < encoderSet.length(); ++j) {
                edges[i2 - 1][j] = null;
            }
        }
        int minimalJ = -1;
        int minimalSize = Integer.MAX_VALUE;
        for (int j = 0; j < encoderSet.length(); ++j) {
            InputEdge edge;
            if (edges[inputLength][j] == null || (edge = edges[inputLength][j]).cachedTotalSize >= minimalSize) continue;
            minimalSize = edge.cachedTotalSize;
            minimalJ = j;
        }
        if (minimalJ < 0) {
            throw new RuntimeException("Internal error: failed to encode \"" + stringToEncode + "\"");
        }
        ArrayList<Integer> intsAL = new ArrayList<Integer>();
        InputEdge current = edges[inputLength][minimalJ];
        while (current != null) {
            int previousEncoderIndex;
            if (current.isFNC1()) {
                intsAL.add(0, 1000);
            } else {
                byte[] bytes = encoderSet.encode(current.c, current.encoderIndex);
                for (i = bytes.length - 1; i >= 0; --i) {
                    intsAL.add(0, bytes[i] & 0xFF);
                }
            }
            int n = previousEncoderIndex = current.previous == null ? 0 : current.previous.encoderIndex;
            if (previousEncoderIndex != current.encoderIndex) {
                intsAL.add(0, 256 + encoderSet.getECIValue(current.encoderIndex));
            }
            current = current.previous;
        }
        int[] ints = new int[intsAL.size()];
        for (i = 0; i < ints.length; ++i) {
            ints[i] = (Integer)intsAL.get(i);
        }
        return ints;
    }

    private static final class InputEdge {
        private final char c;
        private final int encoderIndex;
        private final InputEdge previous;
        private final int cachedTotalSize;

        private InputEdge(char c, ECIEncoderSet encoderSet, int encoderIndex, InputEdge previous, int fnc1) {
            int previousEncoderIndex;
            this.c = (char)(c == fnc1 ? 1000 : (int)c);
            this.encoderIndex = encoderIndex;
            this.previous = previous;
            int size = this.c == '\u03e8' ? 1 : encoderSet.encode(c, encoderIndex).length;
            int n = previousEncoderIndex = previous == null ? 0 : previous.encoderIndex;
            if (previousEncoderIndex != encoderIndex) {
                size += 3;
            }
            if (previous != null) {
                size += previous.cachedTotalSize;
            }
            this.cachedTotalSize = size;
        }

        boolean isFNC1() {
            return this.c == '\u03e8';
        }
    }
}

