/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.rules;

import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.persistence.deploy.DeploymentCache;
import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.repository.Deployment;
import org.kie.api.KieBase;

public class RulesHelper {
    public static KieBase findKnowledgeBaseByDeploymentId(String deploymentId) {
        DeploymentCache<Object> knowledgeBaseCache = CommandContextUtil.getProcessEngineConfiguration().getDeploymentManager().getKnowledgeBaseCache();
        KieBase knowledgeBase = (KieBase)knowledgeBaseCache.get(deploymentId);
        if (knowledgeBase == null) {
            DeploymentEntity deployment = (DeploymentEntity)CommandContextUtil.getDeploymentEntityManager().findById(deploymentId);
            if (deployment == null) {
                throw new FlowableObjectNotFoundException("no deployment with id " + deploymentId, Deployment.class);
            }
            CommandContextUtil.getProcessEngineConfiguration().getDeploymentManager().deploy(deployment);
            knowledgeBase = (KieBase)knowledgeBaseCache.get(deploymentId);
            if (knowledgeBase == null) {
                throw new FlowableException("deployment " + deploymentId + " doesn't contain any rules");
            }
        }
        return knowledgeBase;
    }
}

