/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.jaxrs.ext.search.client.CompleteCondition;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.audit.AuditHistoryModal;
import org.apache.syncope.client.console.layout.AnyLayout;
import org.apache.syncope.client.console.layout.AnyLayoutUtils;
import org.apache.syncope.client.console.notifications.NotificationTasks;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.AnyDirectoryPanel;
import org.apache.syncope.client.console.panels.AnyObjectDirectoryPanel;
import org.apache.syncope.client.console.panels.AnyPanel;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.GroupDisplayAttributesModalPanel;
import org.apache.syncope.client.console.panels.MembersTogglePanel;
import org.apache.syncope.client.console.panels.TypeExtensionDirectoryPanel;
import org.apache.syncope.client.console.panels.UserDirectoryPanel;
import org.apache.syncope.client.console.rest.AnyObjectRestClient;
import org.apache.syncope.client.console.rest.AnyTypeClassRestClient;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.GroupRestClient;
import org.apache.syncope.client.console.rest.RoleRestClient;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.console.tasks.AnyPropagationTasks;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.console.wizards.any.GroupWrapper;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.GroupUR;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyEntitlement;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.ProvisionAction;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class GroupDirectoryPanel
extends AnyDirectoryPanel<GroupTO, GroupRestClient> {
    private static final long serialVersionUID = -1100228004207271270L;
    @SpringBean
    protected AnyTypeRestClient anyTypeRestClient;
    @SpringBean
    protected AnyTypeClassRestClient anyTypeClassRestClient;
    @SpringBean
    protected RoleRestClient roleRestClient;
    @SpringBean
    protected UserRestClient userRestClient;
    @SpringBean
    protected GroupRestClient groupRestClient;
    @SpringBean
    protected AnyObjectRestClient anyObjectRestClient;
    protected final BaseModal<Serializable> typeExtensionsModal = new BaseModal("outer");
    protected final BaseModal<Serializable> membersModal = new BaseModal("outer");
    protected final MembersTogglePanel membersTogglePanel;

    protected GroupDirectoryPanel(String id, Builder builder, boolean wizardInModal) {
        super(id, builder, wizardInModal);
        this.typeExtensionsModal.size(Modal.Size.Large);
        this.addOuterObject(new Component[]{this.typeExtensionsModal});
        this.setWindowClosedReloadCallback(this.typeExtensionsModal);
        this.typeExtensionsModal.addSubmitButton();
        this.addOuterObject(new Component[]{this.membersModal});
        this.membersModal.size(Modal.Size.Large);
        this.membersTogglePanel = new MembersTogglePanel(this.page.getPageReference()){
            private static final long serialVersionUID = -8765794727538618705L;

            @Override
            protected Serializable onApplyInternal(GroupTO groupTO, String type, AjaxRequestTarget target) {
                AnyTypeTO anyType = this.anyTypeRestClient.read(type);
                AnyLayout layout = AnyLayoutUtils.fetch(GroupDirectoryPanel.this.roleRestClient, this.anyTypeRestClient.list());
                Object anyPanel = new AnyPanel.Builder(layout.getAnyPanelClass(), "content", anyType, null, layout, false, this.pageRef).build((id, anyTypeTO, realmTO, anyLayout, pr) -> {
                    WizardMgtPanel panel;
                    if (AnyTypeKind.USER.name().equals(type)) {
                        String query = SyncopeClient.getUserSearchConditionBuilder().and((CompleteCondition)SyncopeClient.getUserSearchConditionBuilder().inGroups(groupTO.getKey(), new String[0]), (CompleteCondition)SyncopeClient.getUserSearchConditionBuilder().is("key").notNullValue(), new CompleteCondition[0]).query();
                        panel = new UserDirectoryPanel.Builder(GroupDirectoryPanel.this.anyTypeClassRestClient.list(anyTypeTO.getClasses()), GroupDirectoryPanel.this.userRestClient, anyTypeTO.getKey(), pr).setRealm(GroupDirectoryPanel.this.realm).setFiltered(true).setFiql(query).disableCheckBoxes().addNewItemPanelBuilder(AnyLayoutUtils.newLayoutInfo(new UserTO(), anyTypeTO.getClasses(), anyLayout.getUser(), GroupDirectoryPanel.this.userRestClient, pr), false).setWizardInModal(false).build(id);
                        MetaDataRoleAuthorizationStrategy.authorize(panel, (Action)WebPage.RENDER, (String)"USER_SEARCH");
                    } else {
                        String query = SyncopeClient.getAnyObjectSearchConditionBuilder((String)type).and((CompleteCondition)SyncopeClient.getUserSearchConditionBuilder().inGroups(groupTO.getKey(), new String[0]), (CompleteCondition)SyncopeClient.getUserSearchConditionBuilder().is("key").notNullValue(), new CompleteCondition[0]).query();
                        panel = new AnyObjectDirectoryPanel.Builder(GroupDirectoryPanel.this.anyTypeClassRestClient.list(anyTypeTO.getClasses()), GroupDirectoryPanel.this.anyObjectRestClient, anyTypeTO.getKey(), pr).setRealm(GroupDirectoryPanel.this.realm).setFiltered(true).setFiql(query).disableCheckBoxes().addNewItemPanelBuilder(AnyLayoutUtils.newLayoutInfo(new AnyObjectTO(), anyTypeTO.getClasses(), layout.getAnyObjects().get(type), GroupDirectoryPanel.this.anyObjectRestClient, pr), false).setWizardInModal(false).build(id);
                        MetaDataRoleAuthorizationStrategy.authorize(panel, (Action)WebPage.RENDER, (String)AnyEntitlement.SEARCH.getFor(anyTypeTO.getKey()));
                    }
                    return panel;
                });
                GroupDirectoryPanel.this.membersModal.header((IModel)new StringResourceModel("group.members", (Component)GroupDirectoryPanel.this, (IModel)Model.of((Serializable)Pair.of((Object)groupTO, (Object)new ResourceModel("anyType." + type, type).getObject()))));
                GroupDirectoryPanel.this.membersModal.setContent((ModalPanel)anyPanel);
                GroupDirectoryPanel.this.membersModal.show(true);
                target.add(new Component[]{GroupDirectoryPanel.this.membersModal});
                return null;
            }
        };
        this.addOuterObject(new Component[]{this.membersTogglePanel});
    }

    @Override
    protected String paginatorRowsKey() {
        return "group.paginator.rows";
    }

    @Override
    protected String[] getDefaultAttributeSelection() {
        return GroupDisplayAttributesModalPanel.DEFAULT_SELECTION;
    }

    @Override
    public ActionsPanel<Serializable> getHeader(String componentId) {
        ActionsPanel<Serializable> panel = super.getHeader(componentId);
        panel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                target.add(new Component[]{GroupDirectoryPanel.this.displayAttributeModal.setContent((ModalPanel)new GroupDisplayAttributesModalPanel(GroupDirectoryPanel.this.displayAttributeModal, GroupDirectoryPanel.this.page.getPageReference(), GroupDirectoryPanel.this.plainSchemas.stream().map(SchemaTO::getKey).collect(Collectors.toList()), GroupDirectoryPanel.this.derSchemas.stream().map(SchemaTO::getKey).collect(Collectors.toList())))});
                GroupDirectoryPanel.this.displayAttributeModal.header((IModel)new ResourceModel("any.attr.display"));
                GroupDirectoryPanel.this.displayAttributeModal.show(true);
            }
        }, ActionLink.ActionType.CHANGE_VIEW, "GROUP_READ").hideLabel();
        return panel;
    }

    @Override
    public ActionsPanel<GroupTO> getActions(final IModel<GroupTO> model) {
        ActionsPanel<GroupTO> actions = super.getActions(model);
        actions.add(new ActionLink<GroupTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, GroupTO ignore) {
                GroupDirectoryPanel.this.send((IEventSink)GroupDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent((Serializable)((Object)new GroupWrapper((GroupTO)((GroupRestClient)GroupDirectoryPanel.this.restClient).read(((GroupTO)model.getObject()).getKey()))), target));
            }
        }, ActionLink.ActionType.EDIT, String.format("%s,%s", "GROUP_READ", "GROUP_UPDATE")).setRealms(this.realm, ((GroupTO)model.getObject()).getDynRealms());
        actions.add(new ActionLink<GroupTO>(){
            private static final long serialVersionUID = 6242834621660352855L;

            @Override
            public void onClick(AjaxRequestTarget target, GroupTO ignore) {
                target.add(new Component[]{GroupDirectoryPanel.this.typeExtensionsModal.setContent((ModalPanel)new TypeExtensionDirectoryPanel(GroupDirectoryPanel.this.typeExtensionsModal, (GroupTO)model.getObject(), GroupDirectoryPanel.this.pageRef))});
                GroupDirectoryPanel.this.typeExtensionsModal.header((IModel)new StringResourceModel("typeExtensions", model));
                GroupDirectoryPanel.this.typeExtensionsModal.show(true);
            }
        }, ActionLink.ActionType.TYPE_EXTENSIONS, "GROUP_UPDATE").setRealms(this.realm, ((GroupTO)model.getObject()).getDynRealms());
        actions.add(new ActionLink<GroupTO>(){
            private static final long serialVersionUID = -7978723352517770645L;

            @Override
            public void onClick(AjaxRequestTarget target, GroupTO ignore) {
                GroupDirectoryPanel.this.membersTogglePanel.setHeader(target, ((GroupTO)model.getObject()).getName());
                GroupDirectoryPanel.this.membersTogglePanel.setTargetObject((GroupTO)model.getObject());
                GroupDirectoryPanel.this.membersTogglePanel.toggle(target, (Serializable)model.getObject(), true);
            }

            @Override
            public boolean isIndicatorEnabled() {
                return false;
            }
        }, ActionLink.ActionType.MEMBERS, String.format("%s,%s", "GROUP_READ", "GROUP_UPDATE")).setRealms(this.realm, ((GroupTO)model.getObject()).getDynRealms());
        ActionLink provisionMembers = new ActionLink<GroupTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, GroupTO ignore) {
                try {
                    GroupDirectoryPanel.this.groupRestClient.provisionMembers(((GroupTO)model.getObject()).getKey(), ProvisionAction.PROVISION);
                    SyncopeConsoleSession.get().success((Serializable)((Object)GroupDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{GroupDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While provisioning members of group {}", (Object)((GroupTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)GroupDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }.confirmMessage("confirmProvisionMembers");
        actions.add(provisionMembers, ActionLink.ActionType.PROVISION_MEMBERS, String.format("%s,%s", "TASK_CREATE", "TASK_EXECUTE"), true).setRealm(this.realm);
        ActionLink deprovisionMembers = new ActionLink<GroupTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, GroupTO ignore) {
                try {
                    GroupDirectoryPanel.this.groupRestClient.provisionMembers(((GroupTO)model.getObject()).getKey(), ProvisionAction.DEPROVISION);
                    SyncopeConsoleSession.get().success((Serializable)((Object)GroupDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{GroupDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While provisioning members of group {}", (Object)((GroupTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)GroupDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }.confirmMessage("confirmDeprovisionMembers");
        actions.add(deprovisionMembers, ActionLink.ActionType.DEPROVISION_MEMBERS, String.format("%s,%s", "TASK_CREATE", "TASK_EXECUTE"), true).setRealm(this.realm);
        SyncopeWebApplication.get().getAnyDirectoryPanelAdditionalActionLinksProvider().get((GroupTO)model.getObject(), this.realm, this.altDefaultModal, this.getString("any.edit", (IModel)new Model((Serializable)((Object)new GroupWrapper((GroupTO)model.getObject())))), this, this.pageRef).forEach(actions::add);
        actions.add(new ActionLink<GroupTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, GroupTO ignore) {
                target.add(new Component[]{GroupDirectoryPanel.this.utilityModal.setContent(new AnyPropagationTasks(GroupDirectoryPanel.this.utilityModal, AnyTypeKind.GROUP, ((GroupTO)model.getObject()).getKey(), GroupDirectoryPanel.this.pageRef))});
                GroupDirectoryPanel.this.utilityModal.header((IModel)new StringResourceModel("any.propagation.tasks", model));
                GroupDirectoryPanel.this.utilityModal.show(true);
            }
        }, ActionLink.ActionType.PROPAGATION_TASKS, "TASK_LIST");
        actions.add(new ActionLink<GroupTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, GroupTO ignore) {
                target.add(new Component[]{GroupDirectoryPanel.this.utilityModal.setContent(new NotificationTasks(AnyTypeKind.GROUP, ((GroupTO)model.getObject()).getKey(), GroupDirectoryPanel.this.pageRef))});
                GroupDirectoryPanel.this.utilityModal.header((IModel)new StringResourceModel("any.notification.tasks", model));
                GroupDirectoryPanel.this.utilityModal.show(true);
            }
        }, ActionLink.ActionType.NOTIFICATION_TASKS, "TASK_LIST");
        actions.add(new ActionLink<GroupTO>(){
            private static final long serialVersionUID = -2878723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, GroupTO ignore) {
                model.setObject((Object)((GroupTO)((GroupRestClient)GroupDirectoryPanel.this.restClient).read(((GroupTO)model.getObject()).getKey())));
                target.add(new Component[]{GroupDirectoryPanel.this.altDefaultModal.setContent(new AuditHistoryModal<GroupTO>(AuditElements.EventCategoryType.LOGIC, "GroupLogic", (GroupTO)model.getObject(), "GROUP_UPDATE", GroupDirectoryPanel.this.auditRestClient){
                    private static final long serialVersionUID = -5819724478921691835L;

                    @Override
                    protected void restore(String json, AjaxRequestTarget target) {
                        GroupTO original = (GroupTO)model.getObject();
                        try {
                            GroupTO updated = (GroupTO)DirectoryPanel.MAPPER.readValue(json, GroupTO.class);
                            GroupUR updateReq = AnyOperations.diff((GroupTO)updated, (GroupTO)original, (boolean)false);
                            ProvisioningResult<GroupTO> result = ((GroupRestClient)GroupDirectoryPanel.this.restClient).update(original.getETagValue(), updateReq);
                            ((GroupTO)model.getObject()).setLastChangeDate(((GroupTO)result.getEntity()).getLastChangeDate());
                            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                            target.add(new Component[]{GroupDirectoryPanel.this.container});
                        }
                        catch (Exception e) {
                            DirectoryPanel.LOG.error("While restoring group {}", (Object)((GroupTO)model.getObject()).getKey(), (Object)e);
                            SyncopeConsoleSession.get().onException(e);
                        }
                        ((BasePage)GroupDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                })});
                GroupDirectoryPanel.this.altDefaultModal.header((IModel)new Model((Serializable)((Object)GroupDirectoryPanel.this.getString("auditHistory.title", (IModel)new Model((Serializable)((Object)new GroupWrapper((GroupTO)model.getObject())))))));
                GroupDirectoryPanel.this.altDefaultModal.show(true);
            }
        }, ActionLink.ActionType.VIEW_AUDIT_HISTORY, String.format("%s,%s", "GROUP_READ", "AUDIT_LIST")).setRealms(this.realm, ((GroupTO)model.getObject()).getDynRealms());
        actions.add(new ActionLink<GroupTO>(){
            private static final long serialVersionUID = 6242834621660352855L;

            @Override
            public void onClick(AjaxRequestTarget target, GroupTO ignore) {
                GroupTO clone = (GroupTO)SerializationUtils.clone((Serializable)((GroupTO)model.getObject()));
                clone.setKey(null);
                GroupDirectoryPanel.this.send((IEventSink)GroupDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.NewItemActionEvent((Serializable)((Object)new GroupWrapper(clone)), target));
            }

            @Override
            protected boolean statusCondition(GroupTO modelObject) {
                return GroupDirectoryPanel.this.realm.startsWith("/");
            }
        }, ActionLink.ActionType.CLONE, "GROUP_CREATE").setRealm(this.realm);
        actions.add(new ActionLink<GroupTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, GroupTO ignore) {
                try {
                    ((GroupRestClient)GroupDirectoryPanel.this.restClient).delete(((GroupTO)model.getObject()).getETagValue(), ((GroupTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)GroupDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{GroupDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While deleting group {}", (Object)((GroupTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)GroupDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }

            @Override
            protected boolean statusCondition(GroupTO modelObject) {
                return GroupDirectoryPanel.this.realm.startsWith("/");
            }
        }, ActionLink.ActionType.DELETE, "GROUP_DELETE", true).setRealm(this.realm);
        return actions;
    }

    public static class Builder
    extends AnyDirectoryPanel.Builder<GroupTO, GroupRestClient> {
        private static final long serialVersionUID = 3844281520756293159L;

        public Builder(List<AnyTypeClassTO> anyTypeClassTOs, GroupRestClient groupRestClient, String type, PageReference pageRef) {
            super(anyTypeClassTOs, groupRestClient, type, pageRef);
            this.setShowResultPage(true);
        }

        @Override
        protected WizardMgtPanel<AnyWrapper<GroupTO>> newInstance(String id, boolean wizardInModal) {
            return new GroupDirectoryPanel(id, this, wizardInModal);
        }
    }
}

