/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.panels;

import java.util.List;
import org.apache.syncope.client.enduser.SyncopeWebApplication;
import org.apache.syncope.client.enduser.layout.UserFormLayoutInfo;
import org.apache.syncope.client.enduser.panels.AbstractAnyFormPanel;
import org.apache.syncope.client.enduser.panels.any.DerAttrs;
import org.apache.syncope.client.enduser.panels.any.Details;
import org.apache.syncope.client.enduser.panels.any.Groups;
import org.apache.syncope.client.enduser.panels.any.PlainAttrs;
import org.apache.syncope.client.enduser.panels.any.Resources;
import org.apache.syncope.client.enduser.panels.any.VirAttrs;
import org.apache.syncope.client.enduser.panels.captcha.CaptchaPanel;
import org.apache.syncope.client.ui.commons.panels.CardPanel;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.client.ui.commons.wizards.any.UserWrapper;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;

public abstract class AnyFormPanel
extends AbstractAnyFormPanel<UserWrapper> {
    private static final long serialVersionUID = -2720486919461006370L;
    protected final List<String> anyTypeClasses;
    protected CaptchaPanel<Void> captcha;
    protected UserFormLayoutInfo formLayoutInfo;

    public AnyFormPanel(String id, UserTO anyTO, List<String> anyTypeClasses, UserFormLayoutInfo formLayoutInfo, PageReference pageReference) {
        super(id, new UserWrapper(anyTO), pageReference);
        this.formLayoutInfo = formLayoutInfo;
        this.anyTypeClasses = anyTypeClasses;
    }

    public AnyFormPanel(String id, UserWrapper wrapper, List<String> anyTypeClasses, UserFormLayoutInfo formLayoutInfo, PageReference pageReference) {
        super(id, wrapper, pageReference);
        this.formLayoutInfo = formLayoutInfo;
        this.anyTypeClasses = anyTypeClasses;
    }

    protected Details<UserTO> addOptionalDetailsPanel(UserWrapper modelObject) {
        Details<UserTO> details = new Details<UserTO>("contentPanel", this.pageRef);
        details.setOutputMarkupId(true);
        return details;
    }

    @Override
    protected void buildLayout(UserWrapper modelObject) {
        this.form.add(new Component[]{new CardPanel.Builder().setName("details").setComponent(this.addOptionalDetailsPanel(modelObject)).isVisible(this.formLayoutInfo.isDetailsManagement()).build("userDetailsPanelCard")});
        Groups groups = new Groups("contentPanel", modelObject);
        this.setOutputMarkupId(true);
        this.form.add(new Component[]{new CardPanel.Builder().setName("groups").setComponent((Component)groups).isVisible(this.formLayoutInfo.isGroups()).build("groupsPanelCard")});
        PlainAttrs plainAttrs = new PlainAttrs("contentPanel", modelObject, this.anyTypeClasses, this.formLayoutInfo.getWhichPlainAttrs());
        plainAttrs.setOutputMarkupId(true);
        this.form.add(new Component[]{new CardPanel.Builder().setName("attributes.plain").setComponent((Component)plainAttrs).isVisible(this.formLayoutInfo.isPlainAttrs() && plainAttrs.isPanelVisible()).build("plainAttrsPanelCard")});
        DerAttrs derAttrs = new DerAttrs("contentPanel", (AnyWrapper<UserTO>)modelObject, this.anyTypeClasses, this.formLayoutInfo.getWhichDerAttrs());
        derAttrs.setOutputMarkupId(true);
        this.form.add(new Component[]{new CardPanel.Builder().setName("attributes.derived").setComponent((Component)derAttrs).isVisible(this.formLayoutInfo.isVirAttrs() && derAttrs.isPanelVisible()).build("derAttrsPanelCard")});
        VirAttrs virAttrs = new VirAttrs("contentPanel", (AnyWrapper<UserTO>)modelObject, this.anyTypeClasses, this.formLayoutInfo.getWhichVirAttrs());
        virAttrs.setOutputMarkupId(true);
        this.form.add(new Component[]{new CardPanel.Builder().setName("attributes.virtual").setComponent((Component)virAttrs).isVisible(this.formLayoutInfo.isVirAttrs() && virAttrs.isPanelVisible()).build("virAttrsPanelCard")});
        Resources resources = new Resources("contentPanel", modelObject);
        resources.setOutputMarkupId(true);
        this.form.add(new Component[]{new CardPanel.Builder().setName("resources").setComponent((Component)resources).isVisible(this.formLayoutInfo.isResources()).build("resourcesPanelCard")});
        this.captcha = new CaptchaPanel("contentPanel");
        this.captcha.setOutputMarkupPlaceholderTag(true);
        this.form.add(new Component[]{new CardPanel.Builder().setName("captcha").setComponent(this.captcha).isVisible(SyncopeWebApplication.get().isCaptchaEnabled()).build("captchaPanelCard")});
    }

    protected void fixPlainAndVirAttrs(AnyTO updated, AnyTO original) {
        for (Attr plainAttr : original.getPlainAttrs()) {
            if (!updated.getPlainAttr(plainAttr.getSchema()).isEmpty()) continue;
            updated.getPlainAttrs().add(plainAttr);
        }
        for (Attr virAttr : original.getVirAttrs()) {
            if (!updated.getVirAttr(virAttr.getSchema()).isEmpty()) continue;
            updated.getVirAttrs().add(virAttr);
        }
        if (updated instanceof GroupableRelatableTO && original instanceof GroupableRelatableTO) {
            ((GroupableRelatableTO)GroupableRelatableTO.class.cast(original)).getMemberships().forEach(oMemb -> ((GroupableRelatableTO)GroupableRelatableTO.class.cast(updated)).getMembership(oMemb.getGroupKey()).ifPresent(uMemb -> {
                oMemb.getPlainAttrs().stream().filter(attr -> uMemb.getPlainAttr(attr.getSchema()).isEmpty()).forEach(attr -> uMemb.getPlainAttrs().add(attr));
                oMemb.getVirAttrs().stream().filter(attr -> uMemb.getVirAttr(attr.getSchema()).isEmpty()).forEach(attr -> uMemb.getVirAttrs().add(attr));
            }));
        }
        updated.getPlainAttrs().removeIf(attr -> attr.getValues().isEmpty());
        updated.getVirAttrs().removeIf(attr -> attr.getValues().isEmpty());
        if (updated instanceof GroupableRelatableTO) {
            ((GroupableRelatableTO)GroupableRelatableTO.class.cast(updated)).getMemberships().forEach(memb -> {
                memb.getPlainAttrs().removeIf(attr -> attr.getValues().isEmpty());
                memb.getVirAttrs().removeIf(attr -> attr.getValues().isEmpty());
            });
        }
    }
}

