/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed;

import io.github.bucket4j.distributed.remote.RemoteBucketState;
import java.time.Duration;

public interface ExpirationAfterWriteStrategy {
    public long calculateTimeToLiveMillis(RemoteBucketState var1, long var2);

    public static ExpirationAfterWriteStrategy none() {
        return (state, currentTimeNanos) -> -1L;
    }

    public static ExpirationAfterWriteStrategy fixedTimeToLive(Duration ttl) {
        long ttlMillis = ttl.toMillis();
        if (ttlMillis <= 0L) {
            throw new IllegalArgumentException("ttl should be positive");
        }
        return (state, currentTimeNanos) -> ttlMillis;
    }

    public static ExpirationAfterWriteStrategy basedOnTimeForRefillingBucketUpToMax(Duration keepAfterRefillDuration) {
        long keepAfterRefillDurationMillis = keepAfterRefillDuration.toMillis();
        if (keepAfterRefillDurationMillis < 0L) {
            throw new IllegalArgumentException("keepAfterRefillDurationMillis should be positive");
        }
        return (state, currentTimeNanos) -> {
            long millisToFullRefill = state.calculateFullRefillingTime(currentTimeNanos) / 1000000L;
            long result = keepAfterRefillDurationMillis + millisToFullRefill;
            return result <= 0L ? 1L : result;
        };
    }
}

